//
//  EventResponse.swift
//  BeInBeOutAMCO
//
//  Created by My on 12/09/23.
//

import Foundation
class EventResponse: Decodable {
    var response: String = ""
    var totalAmount: Double = 0
    var walletBalance: Double = 0

    enum CodingKeys: CodingKey {
        case response
        case totalAmount
        case walletBalance
    }

    required init(from decoder: Decoder) throws {
        let container = try decoder.container(keyedBy: CodingKeys.self)
        self.response = try container.decode(String.self, forKey: .response)

        if let priceValue = try? container.decode(Double.self, forKey: .totalAmount) {
            // Successfully decoded as an Int
            self.totalAmount = priceValue
        } else {
            let priceInt = try container.decode(Int.self, forKey: .totalAmount)
            self.totalAmount = Double(priceInt)
        }

        if let walletValue = try? container.decode(Double.self, forKey: .walletBalance) {
            // Successfully decoded as an Int
            self.walletBalance = walletValue
        } else {
            let walletInt = try container.decode(Int.self, forKey: .walletBalance)
            self.walletBalance = Double(walletInt)
        }
    }
}
