//
//  AppDelegate.swift
//  BeIn-BeOut-AMCO
//
//  Created by Mac-07 on 31/05/23.
//

import Firebase
import FirebaseCore
import FirebaseMessaging
import FirebaseRemoteConfig
import Foundation
import IQKeyboardManagerSwift
import Siren
import UIKit

@main
class AppDelegate: UIResponder, UIApplicationDelegate {
    func application(_ application: UIApplication, didFinishLaunchingWithOptions _: [UIApplication.LaunchOptionsKey: Any]?) -> Bool {
        // Override point for customization after application launch.

        // Request Notification permission.
//        FirebaseApp.configure()
//        getRemoteConfig()
//        Messaging.messaging().delegate = self
        UIApplication.shared.applicationIconBadgeNumber = 0
        IQKeyboardManager.shared.enable = true

//        #if DEBUG
//            Crashlytics.crashlytics().setCrashlyticsCollectionEnabled(false)
//        #endif
        UNUserNotificationCenter.current().delegate = self

        if #available(iOS 10.0, *) {
            // For iOS 10 display notification (sent via APNS)

            var authOptions: UNAuthorizationOptions?
            if #available(iOS 12.0, *) {
                authOptions = [.alert, .badge, .sound] // .criticalAlert
            } else {
                authOptions = [.alert, .badge, .sound]
            }

            UNUserNotificationCenter.current().requestAuthorization(
                options: authOptions!,
                completionHandler: { _, _ in }
            )
            application.registerForRemoteNotifications()
        } else {
            let settings: UIUserNotificationSettings =
                .init(types: [.alert, .badge, .sound], categories: nil)
            application.registerUserNotificationSettings(settings)
        }
        DatabaseManager.shared.setupDatabase()

        var firstRun = UserDefaults.standard.bool(forKey: "HasBuildBefore")
        if !firstRun {
            Helper.addCustomer()
            Helper.addRoute()
            Helper.addBusStop()
            firstRun=true
            UserDefaults.standard.set(firstRun, forKey: "HasBuildBefore")
        }
//        if AccountRepository.isUserLoggedIn {
//            NavigationHelper.showMyProfileVC(nil, asRootVC: true)
//        }

        return true
    }

    // MARK: UISceneSession Lifecycle

    @available(iOS 13.0, *)
    func application(_: UIApplication, configurationForConnecting connectingSceneSession: UISceneSession, options _: UIScene.ConnectionOptions) -> UISceneConfiguration {
        // Called when a new scene session is being created.
        // Use this method to select a configuration to create the new scene with.
        return UISceneConfiguration(name: "Default Configuration", sessionRole: connectingSceneSession.role)
    }

    @available(iOS 13.0, *)
    func application(_: UIApplication, didDiscardSceneSessions _: Set<UISceneSession>) {
        // Called when the user discards a scene session.
        // If any sessions were discarded while the application was not running, this will be called shortly after application:didFinishLaunchingWithOptions.
        // Use this method to release any resources that were specific to the discarded scenes, as they will not return.
    }
}

// Handle Notification
extension AppDelegate: UNUserNotificationCenterDelegate {
    // Receive displayed notifications for iOS 10 devices.
    func userNotificationCenter(_: UNUserNotificationCenter,
                                willPresent notification: UNNotification,
                                withCompletionHandler completionHandler: @escaping (UNNotificationPresentationOptions) -> Void)
    {
        let userInfo = notification.request.content.userInfo

        debugPrint(userInfo)
        debugPrint("Notification : When app is in forground & notification arrives, this function will be executed.")
        // Change this to your preferred presentation option
        completionHandler([[.sound, .badge]])
    }

    func userNotificationCenter(_: UNUserNotificationCenter,
                                didReceive response: UNNotificationResponse,
                                withCompletionHandler completionHandler: @escaping () -> Void)
    {
        let userInfo = response.notification.request.content.userInfo
        debugPrint("Notification: Whether app is in bg or fg, When notification clicked, this function will be executed")
        debugPrint(userInfo)

        navigateToLivePreviewScreen(userInfo: userInfo)
        completionHandler()
    }

    func navigateToLivePreviewScreen(userInfo _: [AnyHashable: Any]) {
        let seconds = 0.5
        DispatchQueue.main.asyncAfter(deadline: .now() + seconds) {
            // Redirect user to screen with userInfo, from where we handle the notification
        }
    }
}

extension AppDelegate: MessagingDelegate {
    func application(application _: UIApplication,
                     didRegisterForRemoteNotificationsWithDeviceToken deviceToken: Data)
    {
        Messaging.messaging().apnsToken = deviceToken
    }

    func messaging(_: Messaging, didReceiveRegistrationToken fcmToken: String?) {
        AccountRepository.setAccessToken(fcmToken ?? "")
        debugPrint(fcmToken ?? "")
    }

    func application(_: UIApplication, didReceiveRemoteNotification userInfo: [AnyHashable: Any], fetchCompletionHandler _: @escaping (UIBackgroundFetchResult) -> Void) {
        // Print full message.
        debugPrint(userInfo)
        UIApplication.shared.applicationIconBadgeNumber = 0
    }
}

extension AppDelegate {
//    func getRemoteConfig() {
//        if Helper.checkInternetConnection(giveErrorMessage: false) {
//            let remoteConfig = RemoteConfig.remoteConfig()
//
//            remoteConfig.fetchAndActivate { _, error in
//                if let error = error {
//                    debugPrint("Error fetching remote config: \(error.localizedDescription)")
//                    return
//                }
//
//                // Read the value from the remote configuration
//
//                let minimuSupportedAppVersioniOS = remoteConfig.configValue(forKey: "minimum_supported_app_version_ios").numberValue.doubleValue
//                debugPrint("Remote config minimuSupportedAppVersioniOS value: \(minimuSupportedAppVersioniOS)")
//
//                let isUnderMaintenanceiOS = remoteConfig.configValue(forKey: "is_under_maintenance_ios").boolValue
//                debugPrint("Remote config isUnderMaintenanceiOS value: \(isUnderMaintenanceiOS)")
//
//                if isUnderMaintenanceiOS {
//                    // If iOS app is under maintenance, we will show the maintenance screen as Root VC.
////                    NavigationHelper.showAppUpdateScreen(nil, asRootVC: true, isUnderMaintenance: true)
//                } else if Helper.getBuildVersion().doubleValue < minimuSupportedAppVersioniOS {
//                    // If app's current version is less then minimum supported app version ios, we will show the app update screen as root vc. [Force fully update]
////                    NavigationHelper.showAppUpdateScreen(nil, asRootVC: true)
//                } else {
//                    Siren.shared.wail()
//                }
//            }
//        }
//    }
}
