package com.amco.bein_beout.util.helper

import android.app.Activity
import android.app.Dialog
import android.content.Context
import android.content.pm.PackageManager
import android.net.ConnectivityManager
import android.net.NetworkCapabilities
import android.os.Build
import android.view.Gravity
import android.view.LayoutInflater
import android.view.View
import android.view.WindowManager
import android.view.inputmethod.InputMethodManager
import android.widget.TextView
import android.widget.Toast
import androidx.appcompat.app.AppCompatDelegate
import androidx.fragment.app.Fragment
import com.google.android.material.snackbar.Snackbar
import com.amco.bein_beout.R
import com.amco.bein_beout.databinding.LayoutCommonProgressBarBinding

object Helper {


    fun isNetworkAvailable(context: Context): Boolean {
        val connectivityManager =
            context.getSystemService(Context.CONNECTIVITY_SERVICE) as ConnectivityManager
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q) {
            val capabilities = connectivityManager.getNetworkCapabilities(connectivityManager.activeNetwork)
            if (capabilities != null) {
                when {
                    capabilities.hasTransport(NetworkCapabilities.TRANSPORT_CELLULAR) -> {
                        return true
                    }
                    capabilities.hasTransport(NetworkCapabilities.TRANSPORT_WIFI) -> {
                        return true
                    }
                    capabilities.hasTransport(NetworkCapabilities.TRANSPORT_ETHERNET) -> {
                        return true
                    }
                }
            }
        } else {
            val activeNetworkInfo = connectivityManager.activeNetworkInfo
            if (activeNetworkInfo != null && activeNetworkInfo.isConnected) {
                return true
            }
        }

        return false
    }

    fun getVersion(context: Context): String {
        var versionName = "1.0"
        try {
            versionName = context.packageManager.getPackageInfo(context.packageName, 0).versionName
        } catch (e: PackageManager.NameNotFoundException) {
            e.printStackTrace()
        }
        return versionName
    }

    fun toast(message: String, context: Context, length: Int = Toast.LENGTH_LONG){
        Toast.makeText(context,message,length).show()
    }


    fun  showMessage(
        message: String,
        view: View? = null,
        context: Context,
        isSuccess:Boolean = false,
        length: Int = Snackbar.LENGTH_LONG
    ) {

        val snackBar = com.google.android.material.snackbar.Snackbar.make(view!!, message, com.google.android.material.snackbar.Snackbar.LENGTH_LONG)

        val tvSnackBar =
            snackBar.view.findViewById<TextView>(com.google.android.material.R.id.snackbar_text)
        snackBar.view.setPadding(0, 0, 0, 0)
        tvSnackBar.maxLines = 3

        tvSnackBar.setTextColor(androidx.core.content.ContextCompat.getColor(context, R.color.colorWhite))
        snackBar.setBackgroundTint(
            androidx.core.content.ContextCompat.getColor(context,
            when (isSuccess) {
                true -> R.color.colorPrimary
                false -> R.color.colorAccent
                else -> R.color.black
            }
        )
        )
        snackBar.show()

    }

    fun disableNightMode(){
        AppCompatDelegate.setDefaultNightMode(AppCompatDelegate.MODE_NIGHT_NO)
    }

    fun progressDialog(
        context: Context,
        message: String = context.resources.getString(R.string.please_wait),
    ): Dialog {
        val dialog = Dialog(context)
        val dialogBinding = LayoutCommonProgressBarBinding.inflate(LayoutInflater.from(context))
        dialog.setContentView(dialogBinding.root)
        dialog.setCancelable(false)
        dialog.setCanceledOnTouchOutside(false)
       // dialogBinding.pbMessage.text = message
        //dialog alignment and size code.
        val lp = WindowManager.LayoutParams()
        lp.copyFrom(dialog.window?.attributes)
        lp.width = WindowManager.LayoutParams.MATCH_PARENT
        lp.height = WindowManager.LayoutParams.WRAP_CONTENT
        lp.gravity = Gravity.CENTER
        dialog.window?.attributes = lp
        return dialog
    }



    /**
     * Hide soft input keyboard
     */
    fun Activity.hideKeyboard() {
        val view = window.decorView.rootView
        val inputManager = getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
        inputManager.hideSoftInputFromWindow(view.windowToken, InputMethodManager.HIDE_NOT_ALWAYS)
    }

    fun Fragment.hideKeyboard() {
        val view = activity?.window?.decorView?.rootView
        val inputManager = activity?.getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
        inputManager.hideSoftInputFromWindow(view?.windowToken, InputMethodManager.HIDE_NOT_ALWAYS)
    }
}