package com.amco.bein_beout.util.extension

import android.app.Activity
import android.content.Context
import android.view.View
import android.view.inputmethod.InputMethodManager



/**
 * Show soft input keyboard
 */
fun Activity.showKeyBoard(view: View?) {
    if (view!=null)
    {
        view.requestFocus()
        val imm = getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
        imm.showSoftInput(view, InputMethodManager.SHOW_IMPLICIT)
        imm.restartInput(view)
    }else
    {
        hideKeyboard()
    }
}

/**
 * Hide soft input keyboard
 */
fun Activity.hideKeyboard() {
    val view = window.decorView.rootView
    val inputManager = getSystemService(Context.INPUT_METHOD_SERVICE) as InputMethodManager
    inputManager.hideSoftInputFromWindow(view.windowToken, InputMethodManager.HIDE_NOT_ALWAYS)
}