package com.amco.bein_beout.util

import android.content.Context
import android.content.SharedPreferences

class SessionManager(context: Context) {

    private val pref: SharedPreferences
    private val editor: SharedPreferences.Editor
    private val PREF_NAME = "Amco"

    companion object {
        private const val DEVICE_ID = "deviceId"
        private const val USER_ID = "userId"
        private const val USER_NAME = "userName"
        private const val EMAIL = "email"
        private const val FIRST_NAME = "firstName"
        private const val LAST_NAME = "lastName"
        private const val ACTIVE_TICKET = "activeTicket"
        private const val ACCESS_TOKEN = "accessToken"
        private const val DEVICE_UUID = "deviceUuid"
        private const val USER_TOKEN = "userToken"
        private const val EVENT_UUID = "eventUuid"
        private const val WALLET_AMOUNT = "walletAmount"
    }

    init {
        this.pref = context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE)
        this.editor = pref.edit()
    }

    fun logout() {
        val deviceId = deviceId
        val userId = userId
        val userName = userName
        val firstName = firstName
        val lastName = lastName
        val email = email
        val activeTicket = activeTicket
        val userToken = userToken

        editor.clear().commit()

        this.deviceId = deviceId
        this.userId = userId
        this.userName = userName
        this.firstName = firstName
        this.lastName = lastName
        this.email = email
        this.activeTicket = activeTicket
        this.userToken = userToken
    }
    var email: String?
        get() = pref.getString(EMAIL,"")
        set(email) {
            editor.putString(EMAIL, email)
            editor.commit()
        }
    var deviceId: String?
        get() = pref.getString(DEVICE_ID, "")
        set(deviceId) {
            editor.putString(DEVICE_ID, deviceId)
            editor.commit()
        }
    var userId: String?
        get() = pref.getString(USER_ID, "")
        set(userId) {
            editor.putString(USER_ID, userId)
            editor.commit()
        }
    var userName: String?
        get() = pref.getString(USER_NAME, "")
        set(userName) {
            editor.putString(USER_NAME, userName)
            editor.commit()
        }
    var deviceUuid: String?
        get() = pref.getString(DEVICE_UUID, "")
        set(deviceUuid) {
            editor.putString(DEVICE_UUID, deviceUuid)
            editor.commit()
        }
    var eventUuid: String?
        get() = pref.getString(EVENT_UUID, "")
        set(eventUuid) {
            editor.putString(EVENT_UUID, eventUuid)
            editor.commit()
        }
    var activeTicket: String?
        get() = pref.getString(ACTIVE_TICKET,"")
        set(activeTicket) {
            editor.putString(ACTIVE_TICKET, activeTicket)
            editor.commit()
        }

    var accessToken: String?
        get() = pref.getString(ACCESS_TOKEN,"")
        set(AccessToken) {
            editor.putString(ACCESS_TOKEN, AccessToken)
            editor.commit()
        }

    var firstName: String?
        get() = pref.getString(FIRST_NAME,"")
        set(FirstName) {
            editor.putString(FIRST_NAME, FirstName)
            editor.commit()
        }

    var lastName: String?
        get() = pref.getString(LAST_NAME,"")
        set(LastName) {
            editor.putString(LAST_NAME, LastName)
            editor.commit()
        }

    var userToken: String?
        get() = pref.getString(USER_TOKEN,"")
        set(UserToken) {
            editor.putString(USER_TOKEN, UserToken)
            editor.commit()
        }

    var walletAmount: String?
        get() = pref.getString(WALLET_AMOUNT,"")
        set(WalletAmount) {
            editor.putString(WALLET_AMOUNT, WalletAmount)
            editor.commit()
        }
    // set double value from Shared Preferences
    private fun SharedPreferences.Editor.putDouble(key: String, double: Double) =
        putLong(key, java.lang.Double.doubleToRawLongBits(double))

    // get double value from Shared Preferences
    private fun SharedPreferences.getDouble(key: String, default: Double) =
        java.lang.Double.longBitsToDouble(
            getLong(
                key,
                java.lang.Double.doubleToRawLongBits(default)
            )
        )

}
