package com.amco.bein_beout.util

import android.app.TimePickerDialog
import android.content.Context
import com.amco.bein_beout.`interface`.TimePickerCallback
import java.text.SimpleDateFormat
import java.util.*

object MyTimePicker {

    lateinit var simpleDateFormat: SimpleDateFormat
    lateinit var output: String

    fun starTimePicker(
        mContext: Context,
        calendar: Calendar?,
        requestCode: Int?,
        is24HourView: Boolean,
        callback: TimePickerCallback
    ) {
        val mCalendar = Calendar.getInstance().takeIf { calendar == null } ?: calendar!!

        val initialHour = mCalendar.get(Calendar.HOUR_OF_DAY)
        val initialMinute = mCalendar.get(Calendar.MINUTE)

        val timePickerDialog = TimePickerDialog(
            mContext,
            { view, hourOfDay, minute ->

                if (is24HourView) {
                    simpleDateFormat = SimpleDateFormat("HH:mm", Locale.getDefault())
                    output = simpleDateFormat.format(
                        simpleDateFormat.parse("$hourOfDay:$minute")!!
                    )

                } else {
                    val am_pm = "AM".takeIf { hourOfDay < 12 } ?: "PM"
                    simpleDateFormat = SimpleDateFormat("HH:mm a", Locale.getDefault())
                    output = simpleDateFormat.format(
                        simpleDateFormat.parse("$hourOfDay:$minute $am_pm")!!
                    )
                }

                callback.onTimeSelected(output, requestCode.takeIf { requestCode != null }
                    ?: -1)

            }, initialHour, initialMinute, is24HourView
        )
        timePickerDialog.show()
    }
}