package com.amco.bein_beout.util

import android.app.DatePickerDialog
import android.content.Context
import com.amco.bein_beout.`interface`.DatePickerCallback
import java.util.*


object MyDatePicker {
    lateinit var datePickerDialog: DatePickerDialog

    fun starDatePicker(
        mContext: Context,
        calendar: Calendar?,
        fromCalendar: Calendar?,
        requestCode: Int?,
        isEditMode: Boolean,
        yearOuter: Int,
        monthOuter: Int,
        dayOfMonthOuter: Int,
        isFutureDateVisible: Boolean,
        callback: DatePickerCallback,
    ) {
        val mCalendar = Calendar.getInstance()

        val initialYear = mCalendar.get(Calendar.YEAR)
        val initialMonth = mCalendar.get(Calendar.MONTH)
        val initialDay = mCalendar.get(Calendar.DAY_OF_MONTH)

        datePickerDialog = DatePickerDialog(
            mContext,
            { view, year, month, dayOfMonth ->
                val mont = month + 1
                mCalendar.set(year, mont, dayOfMonth, 0, 0, 0)
                callback.onDateSelected(mCalendar, requestCode.takeIf { requestCode != null } ?: -1)
            }, initialYear, initialMonth, initialDay
        )


        if (isEditMode) {
            datePickerDialog.updateDate(yearOuter, monthOuter - 1, dayOfMonthOuter)
        } else if (fromCalendar != null) {
            datePickerDialog.datePicker.minDate = fromCalendar.timeInMillis
        }

        if (!isFutureDateVisible) {
            datePickerDialog.datePicker.maxDate = System.currentTimeMillis() - 1
        }

        datePickerDialog.show()
    }
}