package com.amco.bein_beout.util

import com.amco.bein_beout.util.constant.Constant
import com.google.firebase.crashlytics.FirebaseCrashlytics


/**
 * Firebase Crashlytics helper class - responsible to cover the methods
 * to generate custom log keys - used in order to identify the user uniquely
 * with the help of these methods.
 * */

class CrashlyticsHelper {
    companion object CrashlyticsHelperObject {
        private val crashlyticsHelper = FirebaseCrashlytics.getInstance()

        /**
         * Sets user id to Firebase crashlytics
         * So it can be seen when crash logs are generated.
         * @param userId
         * */
        fun setUserIdKey(userId: String) {
            crashlyticsHelper.setUserId(userId)
        }

        /**
         * Sets language to Firebase crashlytics
         * So it can be seen when crash logs are generated.
         * @param accountKey
         * */
        fun setAccountKey(accountKey: String) {
//            val dbHelper = DatabaseHelper(context)
//            //set language based on language Id value stored in db.
//            val languageId = dbHelper.languageId
//            val languageArrayEng: Array<String> =
//                context.resources.getStringArray(R.array.language_array_eng)
            crashlyticsHelper.setCustomKey(
                Constant.CUSTOM_KEY_ACCOUT,
                accountKey
            )
        }

        /**
         * Sets book key to Firebase crashlytics
         * So it can be seen when crash logs are generated.
         * @param eventHistory
         * */
        fun setEventHistoryKey(eventHistory: String) {
            crashlyticsHelper.setCustomKey(Constant.CUSTOM_KEY_EVENTS_HISTORY, eventHistory)
        }

        /**
         * Sets book key to Firebase crashlytics
         * So it can be seen when crash logs are generated.
         * @param eventKey
         * */
        fun setEventsKey(eventKey: String) {
            crashlyticsHelper.setCustomKey(Constant.CUSTOM_KEY_EVENT, eventKey)
        }

        /**
         * Stores all the keys to crashlytics instance from
         * shared preference values stored
         * */
       /* fun setAllKeys(context: Context) {
            val sessionManager = SessionManager(context)
            sessionManager.userServerId?.let {
                setUserIdKey(sessionManager.userServerId)
            }
            //set language
            setLanguageKey(CommonUtility.getLanguageFromShortLanguage(sessionManager.language))
            //default book key set as blank
            setBookKey("")
            //default chapter key set as 0.
            setChapterKey(0)
        }*/
    }
}