package com.amco.bein_beout.remote


import android.content.Context
import android.util.Log
import com.amco.bein_beout.util.SessionManager
import com.google.gson.JsonElement
import okhttp3.MediaType.Companion.toMediaTypeOrNull
import okhttp3.RequestBody
import okhttp3.RequestBody.Companion.toRequestBody
import org.json.JSONArray
import org.json.JSONException
import org.json.JSONObject
import retrofit2.Call
import retrofit2.Callback
import retrofit2.Response
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory

class EventsAPI(
    context: Context,
    page: Int,
    size: Int,
    sort: String,
    direction: String,
    customerEmail: String,
    filterValue: ArrayList<String>,
    dateFrom: String,
    dateTo: String,
    val callback: APICallback,
) {


    private var call: Call<JsonElement>? = null
    private var sessionManager: SessionManager? = null

    init {
        sessionManager = SessionManager(context)
        val retrofit = Retrofit.Builder()
            .baseUrl(APICalls.BASE_URL + APICalls.BASE_API_PUB_URL)
            .addConverterFactory(GsonConverterFactory.create())
            .client(context.getOkHttpClient())
            .build()

        val body = JSONObject()

        val statusjsonArray = JSONArray()
        for (i in 0 until filterValue.size) {
            statusjsonArray.put(i, filterValue.get(i))
        }

        try {
            body.put("page", page)
            body.put("size", size) //per page record
            body.put("sort", sort)
            body.put("direction", direction)
            body.put("customerEmail", customerEmail)
            body.put("status", statusjsonArray)
            body.put("dateFrom", dateFrom)
            body.put("dateTo", dateTo)

        } catch (e: JSONException) {
         //   Log.d("onCreate: " + e.message)
        }
        Log.d("Json", body.toString())
        val bodyReq: RequestBody = body.toString()
            .toRequestBody("application/json; charset=utf-8".toMediaTypeOrNull())
        call = retrofit.create(APICalls::class.java).events(bodyReq)
    }

    fun execute(): Call<JsonElement>? {
        Log.e("Json","execute event Api")
        call?.enqueue(object : Callback<JsonElement> {
            override fun onResponse(call: Call<JsonElement>, response: Response<JsonElement>) {
                //Log.d("OnResponse : $response")
                // Handle response here
                if (response.body() != null) {
                    callback.onAPIResult(APICalls.SUCCESS, response.body()!!)
                } else {
                    // Handle failure here
                    callback.onAPIFailure(APICalls.CALL_FAILED)
                }
            }

            override fun onFailure(call: Call<JsonElement>, t: Throwable) {
              //  Log.d("Failure : " + t.localizedMessage)
                // Handle failure here
                callback.onAPIFailure(APICalls.CALL_FAILED)
            }
        })

        return call
    }

    fun cancel() {
        call?.cancel()
    }
}