package com.xpedient.data.remote

import android.content.Context
import com.google.gson.JsonElement
import com.amco.bein_beout.util.constant.AppURL
import okhttp3.OkHttpClient
import okhttp3.Request
import okhttp3.ResponseBody
import retrofit2.Response
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.http.POST
import java.util.concurrent.TimeUnit


interface ApiManagerMaster {

    companion object {

        private const val API_KEY =  "x\$D:)VT}I{"

        private fun getOkHttpClient(context: Context): OkHttpClient {

            var request: Request?
            val httpClient = OkHttpClient.Builder()
                .connectTimeout(4, TimeUnit.MINUTES)
                .readTimeout(4, TimeUnit.MINUTES)
                .writeTimeout(4, TimeUnit.MINUTES)

            httpClient.addInterceptor { chain ->
                val original = chain.request()

                request = when {

                    else -> {
                        original.newBuilder()
                         //   .header("APIKey", API_KEY)
                            .header("Accept", "application/json")
                            .method(original.method, original.body)
                            .build()
                    }
                }

                val response = chain.proceed(request!!)
                val responseBody = response.body
                val contentType = responseBody?.contentType()
                val content = responseBody?.string()



                response.newBuilder().body(ResponseBody.create(contentType, content!!)).build()
            }

            return httpClient.build()
        }

        operator fun invoke(context: Context): ApiManagerMaster {
            val retrofit = Retrofit.Builder()
                .baseUrl(AppURL.API.BASE_URL_MASTER)
                .addConverterFactory(GsonConverterFactory.create())
                .client(getOkHttpClient(context))
                .build()
            return retrofit.create(ApiManagerMaster::class.java)
        }
    }

    @POST(AppURL.API.MasterApi)
    suspend fun getMasterData(): Response<JsonElement>

}