package com.amco.bein_beout.remote

import android.app.Activity
import android.content.Context
import android.content.Intent
import android.widget.Toast
import com.google.gson.Gson
import com.google.gson.GsonBuilder
import com.google.gson.JsonElement
import com.amco.bein_beout.activity.LoginActivity
import com.amco.bein_beout.data.enum.HTTPCode
import com.amco.bein_beout.data.repository.AccountRepository
import com.amco.bein_beout.util.constant.AppURL
import okhttp3.OkHttpClient
import okhttp3.Request
import okhttp3.ResponseBody
import retrofit2.Response
import retrofit2.Retrofit
import retrofit2.converter.gson.GsonConverterFactory
import retrofit2.http.FieldMap
import retrofit2.http.FormUrlEncoded
import retrofit2.http.POST
import java.util.concurrent.TimeUnit


interface APIManager {

    companion object {

        //private const val API_KEY =  "prCwh=2LwCNLAk-CRt2gNE5vdE-y4MqgJF4wLTv5ynnY+"

        private fun getOkHttpClient(context: Context): OkHttpClient {
            var request: Request?

            val httpClient = OkHttpClient.Builder()
                .connectTimeout(4, TimeUnit.MINUTES)
                .readTimeout(4, TimeUnit.MINUTES)
                .writeTimeout(4, TimeUnit.MINUTES)

            httpClient.addInterceptor { chain ->
                val original = chain.request()
                val accountRepository = AccountRepository(context)
                val hasToken = accountRepository.getAccessToken().isNotEmpty()
                request = when {
                    hasToken -> {
                        original.newBuilder()
                           // .header("ApiKey", API_KEY)
                            .header("Accept", "application/json")
                            .header("Authorization", "Bearer " + accountRepository.getAccessToken())
                            .method(original.method, original.body)
                            .build()
                    }
                    else -> {
                        original.newBuilder()
                            //.header("ApiKey", API_KEY)
                            .header("Accept", "application/json")
                            .method(original.method, original.body)
                            .build()
                    }
                }

                val response = chain.proceed(request!!)
                val responseBody = response.body
                val contentType = responseBody?.contentType()
                val content = responseBody?.string()


                try {
                    val objResponse = Gson().fromJson(content, JsonElement::class.java).asJsonObject

                    if (response.code == HTTPCode.FORCE_LOGOUT.code) {
                        try {
                            val message = "can't proceed. Please Login again"

                            if (context is Activity) {
                                context.runOnUiThread {
                                    if (message.isNotBlank()) {
                                        Toast.makeText(context, message, Toast.LENGTH_LONG).show()
                                    }
                                }
                            }
                            accountRepository.logout()
                            context.startActivity(Intent(context, LoginActivity::class.java).addFlags(Intent.FLAG_ACTIVITY_NEW_TASK).addFlags(Intent.FLAG_ACTIVITY_CLEAR_TASK))
                        } catch (e: Exception) {
                            e.printStackTrace()
                        }
                    }
                } catch (e: Exception) {
                    e.printStackTrace()
                }

                response.newBuilder().body(ResponseBody.create(contentType, content!!)).build()
            }

            return httpClient.build()
        }

        operator fun invoke(context: Context): APIManager {
            var gson: Gson? = GsonBuilder()
                .setLenient()
                .create()
            val retrofit = Retrofit.Builder()
                .baseUrl(AppURL.API.BASE_URL)
                .addConverterFactory(GsonConverterFactory.create(gson))
                .client(getOkHttpClient(context))
                .build()
            return retrofit.create(APIManager::class.java)
        }
    }

    @FormUrlEncoded
    @POST(AppURL.API.LOGIN_API)
    suspend fun loginApi(@FieldMap params: Map<String,String>): Response<JsonElement>

    @FormUrlEncoded
    @POST(AppURL.API.SIGN_UP_API)
    suspend fun signUpApi(@FieldMap params: Map<String,String>): Response<JsonElement>

    @FormUrlEncoded
    @POST(AppURL.API.FORGOT_PASSWORD)
    suspend fun forgotPasswordApi(@FieldMap params: Map<String,String>): Response<JsonElement>

    @FormUrlEncoded
    @POST(AppURL.API.RESET_PASSWORD)
    suspend fun resetPasswordApi(@FieldMap params: Map<String,String>): Response<JsonElement>

    @POST(AppURL.API.MasterApi)
    suspend fun getMasterData(): Response<JsonElement>
}