package com.amco.bein_beout.remote

import android.content.Context
import com.amco.bein_beout.util.SessionManager

import okhttp3.Interceptor
import okhttp3.OkHttpClient
import okhttp3.Request
import okhttp3.ResponseBody.Companion.toResponseBody
import java.util.concurrent.TimeUnit

fun Context.getOkHttpClient(hasAccessToken: Boolean = false): OkHttpClient {
    var request: Request? = null
    val sessionManager = SessionManager(this)

    val httpClient = OkHttpClient.Builder()
        .connectTimeout(120, TimeUnit.SECONDS)
        .readTimeout(90, TimeUnit.SECONDS)
        .writeTimeout(90, TimeUnit.SECONDS)

    httpClient.addInterceptor(Interceptor { chain ->
        val original = chain.request()
        request = if (sessionManager.accessToken==null) {
            original.newBuilder()
                .header("Content-Type", "application/json;charset=UTF-8")      // API Header
                .method(original.method, original.body)
                .build()
        } else {
            original.newBuilder()
                /*
                .header(
                    "Authorization",
                    "Bearer " + sessionManager.accessToken.toString()
                )  // API Header*/
                .header("Accept-Language", "en")
                .header("Content-Type", "application/json;charset=UTF-8")
                .method(original.method, original.body)
                .build()
        }

        val response = chain.proceed(request!!)
        val responseBody = response.body
        val contentType = responseBody?.contentType()
        val content = responseBody?.string()

        try {
            response.newBuilder().body(content?.toResponseBody(contentType))
                .build()

        } catch (e: Exception) {
            e.printStackTrace()

            response.newBuilder().body(content?.toResponseBody(contentType))
                .build()
        }
    })

    return httpClient.build()
}