package com.amco.bein_beout.remote

import com.google.gson.JsonElement
import okhttp3.RequestBody
import retrofit2.Call
import retrofit2.http.Body
import retrofit2.http.POST

interface APICalls {

    companion object {
       // const val BASE_URL = "http://185.36.235.119:9080/amfare-larisa/"
        const val BASE_URL = "https://ktelbus.gr/bibo-dev/amfare-admin/"
        const val BASE_API_PUB_URL = "web/api/be_in_be_out/"

        const val LOGIN = "auth/login_user"
        const val LOGIN_CUSTOMER = "auth/login_customer"
        const val EVENT = "event"
        const val EVENTS = "events"

        // API status
        const val CALL_FAILED = -1
        const val FAILURE = 0
        const val SUCCESS = 1
    }

    @POST(LOGIN)
    fun login(@Body params: RequestBody): Call<JsonElement>

    @POST(LOGIN_CUSTOMER)
    fun login_customer(@Body params: RequestBody): Call<JsonElement>

    @POST(EVENT)
    fun event(@Body params: RequestBody): Call<JsonElement>

    @POST(EVENTS)
    fun events(@Body params: RequestBody): Call<JsonElement>
}

interface APICallback {
    fun onAPIResult(status: Int, content: JsonElement? = null)
    fun onAPIFailure(message: Int)
}