package com.amco.bein_beout.local

import android.content.Context
import android.content.SharedPreferences

/**
 * Created by Authentic Android Developer on 02-11-2021.
 */
class PreferenceManager(val context: Context) {

    private val pref: SharedPreferences = context.getSharedPreferences(PREF_NAME, Context.MODE_PRIVATE)
    private val editor: SharedPreferences.Editor

    init {
        this.editor = pref.edit()
        editor.apply()
    }

    companion object {
        private const val PREF_NAME = "Xpedient"

        private object Key {
            const val IS_RECORD_ADDED = "isRecordAdded"
            const val ACCESS_TOKEN = "accessToken"
            const val USER_NAME = "userName"
        }
    }

    var isRecordAdded: Boolean
        get() = pref.getBoolean(Key.IS_RECORD_ADDED, false)
        set(isRecordAdded) {
            editor.putBoolean(Key.IS_RECORD_ADDED,isRecordAdded)
            editor.commit()
        }

    var accessToken: String
        get() = pref.getString(Key.ACCESS_TOKEN,"")?:""
        set(accessToken) {
            editor.putString(Key.ACCESS_TOKEN,accessToken)
            editor.commit()
        }

    var userName: String
        get() = pref.getString(Key.USER_NAME,"")?:""
        set(userName) {
            editor.putString(Key.USER_NAME,userName)
            editor.commit()
        }

    fun clearSession() {
        editor.clear()
        editor.commit()
    }

}