package com.amco.bein_beout.local

import android.annotation.SuppressLint
import android.content.ContentValues
import android.content.Context
import android.database.Cursor
import android.database.sqlite.SQLiteDatabase
import android.database.sqlite.SQLiteException
import android.database.sqlite.SQLiteOpenHelper
import com.amco.bein_beout.data.entity.*
import com.amco.bein_beout.model.BusStop
import com.amco.bein_beout.model.Customers
import com.amco.bein_beout.model.InOutData
import com.amco.bein_beout.model.Route

class DatabaseHelper(context: Context?) :
    SQLiteOpenHelper(context, DATABASE_NAME, null, DATABASE_VERSION) {
    private var context: Context? = null

    init {
        this.context = context
    }

    companion object {
        private val DATABASE_VERSION = 1
        private val DATABASE_NAME = "BeInBeOutDatabase"

        //Routes
        private val TABLE_ROUTES = "RoutesTable"
        //Route Table Key
        private val KEY_ROUTE_ID = "route_id"
        private val KEY_ROUTE_CODE = "route_code"
        private val KEY_ROUTE_VALUE = "route_value"

        //Busstop
        private val TABLE_BUSSTOPS = "BusStopTable"
        //Bus Stop Table Key
        private val KEY_STOP_ID = "stop_id"
        private val KEY_STOP_CODE= "stop_code"
        private val KEY_STOP_VALUE= "stop_value"
        private val KEY_STOP_ROUTE_CODE= "stop_route_code"

        //Customers
        private val TABLE_CUSTOMERS = "CustomersTable"
        //Customers Table Key
        private val KEY_CUSTOMER_ID = "customer_id"
        private val KEY_CUSTOMER_EMAIL= "email"
        private val KEY_CUSTOMER_DATETIME= "customer_date_time"

        //InOut data
        private val TABLE_INOUT = "InOutTable"
        //InOut Table Key
        private val KEY_EVENT_UUID = "event_uuid"
        private val KEY_IN_STATION_CODE= "in_station_code"
        private val KEY_IN_STATION= "in_station"
        private val KEY_IN_TIME= "in_time"
        private val KEY_OUT_TIME= "out_time"
        private val KEY_OUT_STATION= "out_station"
        private val KEY_OUT_STATION_CODE= "out_station_code"
    }

    override fun onCreate(db: SQLiteDatabase?) {
        // TODO("not implemented") //To change body of created functions use File | Settings | File Templates.
        //creating table with fields
        val CREATE_ROUTE_TABLE = ("CREATE TABLE " + TABLE_ROUTES + "("
                + KEY_ROUTE_ID + " INTEGER PRIMARY KEY," + KEY_ROUTE_CODE + " TEXT,"
                + KEY_ROUTE_VALUE + " TEXT" + ")")

        val CREATE_BUS_STOP_TABLE = ("CREATE TABLE " + TABLE_BUSSTOPS + "("
                + KEY_STOP_ID + " INTEGER PRIMARY KEY," + KEY_STOP_CODE + " TEXT,"
                + KEY_STOP_VALUE + " TEXT," +KEY_STOP_ROUTE_CODE + " TEXT" + ")")

        val CREATE_CUSTOMER = ("CREATE TABLE " + TABLE_CUSTOMERS + "("
                + KEY_CUSTOMER_ID + " INTEGER PRIMARY KEY," + KEY_CUSTOMER_EMAIL + " TEXT,"
                + KEY_CUSTOMER_DATETIME + " TEXT" + ")")

        val CREATE_INOUT_TABLE = ("CREATE TABLE " + TABLE_INOUT + "("
                + KEY_EVENT_UUID + " TEXT PRIMARY KEY," + KEY_IN_STATION_CODE + " TEXT,"
                + KEY_IN_STATION + " TEXT," +  KEY_IN_TIME + " TEXT,"+ KEY_OUT_TIME + " TEXT,"
                + KEY_OUT_STATION + " TEXT,"+ KEY_OUT_STATION_CODE + " TEXT" + ")")

        db!!.execSQL(CREATE_ROUTE_TABLE)
        db.execSQL(CREATE_BUS_STOP_TABLE)
        db.execSQL(CREATE_CUSTOMER)
        db.execSQL(CREATE_INOUT_TABLE)
    }

    override fun onUpgrade(db: SQLiteDatabase?, oldVersion: Int, newVersion: Int) {
        //  TODO("not implemented") //To change body of created functions use File | Settings | File Templates.
        db!!.execSQL("DROP TABLE IF EXISTS " + TABLE_ROUTES)
        db.execSQL("DROP TABLE IF EXISTS " + TABLE_BUSSTOPS)
        db.execSQL("DROP TABLE IF EXISTS " + TABLE_CUSTOMERS)
        db.execSQL("DROP TABLE IF EXISTS " + TABLE_INOUT)
        onCreate(db)
    }

    //method to insert data
    fun addRoute(route: Route):Long{
        val db = this.writableDatabase
        val contentValues = ContentValues()
        contentValues.put(KEY_ROUTE_ID, route.routeId)
        contentValues.put(KEY_ROUTE_CODE, route.routeCode)
        contentValues.put(KEY_ROUTE_VALUE,route.routeValue )
        // Inserting Row
        val success = db.insert(TABLE_ROUTES, null, contentValues)
        //2nd argument is String containing nullColumnHack
        //db.close() // Closing database connection
        return success
    }

    //method to insert data
    fun addBusStop(busStop: BusStop):Long{
        val db = this.writableDatabase
        val contentValues = ContentValues()
        contentValues.put(KEY_STOP_ID, busStop.stopId)
        contentValues.put(KEY_STOP_CODE, busStop.stopCode)
        contentValues.put(KEY_STOP_VALUE,busStop.stopValue )
        contentValues.put(KEY_STOP_ROUTE_CODE,busStop.stopRouteCode)
        // Inserting Row
        val success = db.insert(TABLE_BUSSTOPS, null, contentValues)
        //2nd argument is String containing nullColumnHack
         //db.close() // Closing database connection
        return success
    }

    //method to insert data
    fun addCustomers(customers: Customers):Long{
        val db = this.writableDatabase
        val contentValues = ContentValues()
        contentValues.put(KEY_CUSTOMER_ID, customers.id)
        contentValues.put(KEY_CUSTOMER_EMAIL, customers.email)
        contentValues.put(KEY_CUSTOMER_DATETIME,customers.datetime)
        // Inserting Row
        val success = db.insert(TABLE_CUSTOMERS, null, contentValues)
        //2nd argument is String containing nullColumnHack
        // db.close() // Closing database connection
        return success
    }

    //method to insert data
    fun addINData(inoutData: InOutData):Long{
        val db = this.writableDatabase
        val contentValues = ContentValues()
        contentValues.put(KEY_EVENT_UUID, inoutData.eventUuid)
        contentValues.put(KEY_IN_STATION, inoutData.in_station)
        contentValues.put(KEY_IN_STATION_CODE,inoutData.in_station_code)
        contentValues.put(KEY_IN_TIME,inoutData.in_time)
        // Inserting Row
        val success = db.insert(TABLE_INOUT, null, contentValues)
        //2nd argument is String containing nullColumnHack
        // db.close() // Closing database connection
        return success
    }
    fun updateInOutData(beaconId: String,outTime:String,outStationName:String,outStationCode:String):Int{
        val db = this.writableDatabase
        val contentValues = ContentValues()
        contentValues.put(KEY_OUT_STATION, outStationName) // EmpModelClass UserId
        contentValues.put(KEY_OUT_STATION_CODE, outStationCode) // EmpModelClass UserId
        contentValues.put(KEY_OUT_TIME, outTime) // EmpModelClass UserId
        // Deleting Row
        val success = db.update(TABLE_INOUT,contentValues,"beacon_id=?", arrayOf(beaconId))
        //2nd argument is String containing nullColumnHack
       // db.close() // Closing database connection
        return success
    }
    //method to read data
    @SuppressLint("Range")
    fun viewRoutes(RouteId: String):List<Route>{
        val routeList:ArrayList<Route> = ArrayList<Route>()
        val selectQuery = "SELECT  * FROM $TABLE_ROUTES WHERE $KEY_ROUTE_CODE='$RouteId'"
        val db = this.readableDatabase
        var cursor: Cursor? = null
        try{
            cursor = db.rawQuery(selectQuery, null)
        }catch (e: SQLiteException) {
            db.execSQL(selectQuery)
            return ArrayList()
        }
        var routeId: Int
        var routeCode: String
        var routeValue: String
        if (cursor.moveToFirst()) {
            do {
                routeId = cursor.getInt(cursor.getColumnIndex("route_id"))
                routeCode = cursor.getString(cursor.getColumnIndex("route_code"))
                routeValue = cursor.getString(cursor.getColumnIndex("route_value"))
                val routes= Route(routeId = routeId, routeCode = routeCode, routeValue = routeValue)
                routeList.add(routes)
            } while (cursor.moveToNext())
        }
        return routeList
    }

    //method to update data
    fun updateRoutes(route: Route):Int{
        val db = this.writableDatabase
        val contentValues = ContentValues()
        contentValues.put(KEY_ROUTE_ID, route.routeId)
        contentValues.put(KEY_ROUTE_CODE, route.routeCode) // EmpModelClass Name
        contentValues.put(KEY_ROUTE_VALUE,route.routeValue) // EmpModelClass Email

        // Updating Row
        val success = db.update(TABLE_ROUTES, contentValues,"id="+route.routeId,null)
        //2nd argument is String containing nullColumnHack
        db.close() // Closing database connection
        return success
    }
    //method to delete data
    fun deleteRoutes(route: Route):Int{
        val db = this.writableDatabase
        val contentValues = ContentValues()
        contentValues.put(KEY_ROUTE_ID, route.routeId) // EmpModelClass UserId
        // Deleting Row
        val success = db.delete(TABLE_ROUTES,"id="+route.routeId,null)
        //2nd argument is String containing nullColumnHack
        db.close() // Closing database connection
        return success
    }

    @SuppressLint("Range")
    fun viewCustomers():List<Customers>{
        val customerList:ArrayList<Customers> = ArrayList<Customers>()
        val selectQuery = "SELECT  * FROM $TABLE_CUSTOMERS"
        val db = this.readableDatabase
        var cursor: Cursor? = null
        try{
            cursor = db.rawQuery(selectQuery, null)
        }catch (e: SQLiteException) {
            db.execSQL(selectQuery)
            return ArrayList()
        }
        var customerId: Int
        var customerEmail: String
        var customerDateTime: String
        if (cursor.moveToFirst()) {
            do {
                customerId = cursor.getInt(cursor.getColumnIndex("customer_id"))
                customerEmail = cursor.getString(cursor.getColumnIndex("email"))
                customerDateTime = cursor.getString(cursor.getColumnIndex("customer_date_time"))
                val customers= Customers(id = customerId, email = customerEmail, datetime = customerDateTime)
                customerList.add(customers)
            } while (cursor.moveToNext())
        }
        return customerList
    }

    @SuppressLint("Range")
    fun viewBusstop(RouteId: String):List<BusStop>{
        val busstopList:ArrayList<BusStop> = ArrayList<BusStop>()
        val selectQuery = "SELECT * FROM $TABLE_BUSSTOPS WHERE $KEY_STOP_ROUTE_CODE='$RouteId'"
        val db = this.readableDatabase
        var cursor: Cursor? = null
        try{
            cursor = db.rawQuery(selectQuery, null)
        }catch (e: SQLiteException) {
            db.execSQL(selectQuery)
            return ArrayList()
        }
        var stopId: Int
        var stopCode: String
        var stopValue: String
        var stopRouteCode: String
        if (cursor.moveToFirst()) {
            do {
                stopId = cursor.getInt(cursor.getColumnIndex("stop_id"))
                stopCode = cursor.getString(cursor.getColumnIndex("stop_code"))
                stopValue = cursor.getString(cursor.getColumnIndex("stop_value"))
                stopRouteCode = cursor.getString(cursor.getColumnIndex("stop_route_code"))
                val busstops= BusStop(stopId = stopId, stopCode = stopCode, stopValue = stopValue, stopRouteCode =stopRouteCode )
                busstopList.add(busstops)
            } while (cursor.moveToNext())
        }
        return busstopList
    }

}