package com.amco.bein_beout.fragment

import android.annotation.SuppressLint
import android.app.DatePickerDialog
import android.os.Bundle
import android.os.SystemClock
import android.util.Log
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.ListPopupWindow
import android.widget.TextView
import androidx.core.widget.NestedScrollView
import androidx.fragment.app.Fragment
import androidx.recyclerview.widget.LinearLayoutManager
import com.google.gson.Gson
import com.google.gson.JsonElement
import com.google.gson.reflect.TypeToken
import com.amco.bein_beout.R
import com.amco.bein_beout.`interface`.ItemClickCallBack
import com.amco.bein_beout.`interface`.TimePickerCallback
import com.amco.bein_beout.util.SessionManager
import com.amco.bein_beout.adapter.AdapterEventsHistory
import com.amco.bein_beout.adapter.DropDownAdapter
import com.amco.bein_beout.remote.APICallback
import com.amco.bein_beout.remote.APICalls
import com.amco.bein_beout.remote.EventsAPI
import com.amco.bein_beout.util.CrashlyticsHelper
import com.amco.bein_beout.util.MyTimePicker
import com.amco.bein_beout.util.helper.Helper
import com.amco.bein_beout.model.Events
import kotlinx.android.synthetic.main.fragment_events_history.*
import kotlinx.android.synthetic.main.layout_common_progress_bar.*
import kotlinx.android.synthetic.main.layout_no_data.*
import retrofit2.Call
import java.util.*
import kotlin.collections.ArrayList


class EventsHistoryFragment : Fragment(),View.OnClickListener  {
    private var call: Call<JsonElement>? = null
    private lateinit var sessionManager: SessionManager
    private var filterValue:String=""
    var eventsArrayList: ArrayList<Events> = ArrayList()
    var page = 1
    var paginationTotal = 1
    var perPage = 10
    lateinit var adapterEventHistory: AdapterEventsHistory
    lateinit var linearLayoutManager: LinearLayoutManager
    var mLastClickTime: Long = 0
    val filterValues: ArrayList<String> = ArrayList()
    var statusArrayList = ArrayList<String>()

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?,
    ): View? {
        return inflater.inflate(R.layout.fragment_events_history, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        sessionManager = SessionManager(requireContext())
        init()
    }

    private fun init() {
        statusArrayList.clear()
        if(!filterValue.equals("")){
            filterValues.add(filterValue)
        }

        statusArrayList.add(resources.getString(R.string.all))
        statusArrayList.add(resources.getString(R.string.payments))
        statusArrayList.add(resources.getString(R.string.trips))

        tvStatusFilter.setOnClickListener(this)
        tvStartDate.setOnClickListener(this)
        tvEndDate.setOnClickListener(this)
        btnGO.setOnClickListener(this)
        btnClear.setOnClickListener(this)
        setEventsRecyclerView(filterValues,"","")

        //crash analytics for apply filter in Events History
        CrashlyticsHelper.setEventHistoryKey(filterValues.toString())
    }

    private fun getEventsApiCall(
        filterValues: ArrayList<String>,
        startDate: String,
        endDate: String
    ) {
        if (eventsArrayList.isEmpty()) {
            pbFragevents.visibility=View.VISIBLE
        }
        call = EventsAPI(
            requireContext(),
            page,
            perPage,
            "id",
            "DESC",
            sessionManager.email.toString(),
            filterValues,
            startDate,
            endDate,
            object : APICallback {
                override fun onAPIFailure(message: Int) {
                    Log.i("API_FAIL1", message.toString())
                    showError(getString(R.string.error_msg))
                }

                @SuppressLint("NotifyDataSetChanged")
                override fun onAPIResult(status: Int, content: JsonElement?) {
                    if (content != null) {
                        when (status) {
                            APICalls.SUCCESS -> {
                                pbFragevents.visibility=View.GONE
                                eventsArrayList.addAll(Gson().fromJson(
                                        content.asJsonObject.getAsJsonObject("data").get("data").asJsonArray,
                                        object : TypeToken<ArrayList<Events>>() {}.type))

                                val totalItemData=content.asJsonObject.getAsJsonObject("data").get("total").asJsonPrimitive.toString()
                                val totalItemCount=Integer.parseInt(totalItemData)
                                var result: Int  = (totalItemCount / perPage)
                                result = if (totalItemCount % perPage == 0) result else (result + 1)
                                paginationTotal=result
                                Log.i("paginationTotal", paginationTotal.toString())
                                adapterEventHistory.notifyDataSetChanged()

                                rvEventsHistory.visibility = View.VISIBLE
                                llNoData.visibility = View.GONE

                                if (eventsArrayList.isEmpty()) {
                                    rvEventsHistory.visibility = View.GONE
                                    llNoData.visibility = View.VISIBLE
                                }

                            }
                            APICalls.FAILURE -> {
                                Log.i("API_FAIL2", content.toString())
                                showError(getString(R.string.error_msg))
                                if (eventsArrayList.isEmpty()) {
                                    rvEventsHistory.visibility = View.GONE
                                    llNoData.visibility = View.VISIBLE
                                }
                            }
                        }
                    } else {
                        Log.i("API_FAIL3", content.toString())
                        showError(getString(R.string.error_msg))
                    }
                }
            }).execute()
    }

    private fun showError(message: String, isSuccess: Boolean = false) {
        if (message.isNotEmpty()) {
            Helper.toast( message, requireContext())
        }
    }

    private fun setEventsRecyclerView(filterValues: ArrayList<String>,startDate:String,endDate:String) {
        linearLayoutManager = LinearLayoutManager(requireContext())

        nsvEvents.setOnScrollChangeListener(NestedScrollView.OnScrollChangeListener { v, scrollX, scrollY, oldScrollX, oldScrollY ->
            if (v.getChildAt(v.getChildCount() - 1) != null) {
                if ((scrollY >= (v.getChildAt(v.childCount - 1).measuredHeight - v.measuredHeight)) && scrollY > oldScrollY) {
                    //pagination code
                    if (paginationTotal != page) {
                        if (SystemClock.elapsedRealtime() - mLastClickTime < 1000) {
                            return@OnScrollChangeListener
                        }
                        mLastClickTime = SystemClock.elapsedRealtime()
                      //  LogHelper.i(TAG, "Current Page= $page")
                        page += 1
                       // LogHelper.i(TAG, "New Page= $page")
                        getEventsApiCall(filterValues,
                            startDate,
                            endDate)
                    }
                }
            }
        })

        adapterEventHistory = AdapterEventsHistory(
            requireContext(), eventsArrayList, object : ItemClickCallBack {
                override fun onItemClick(position: Int) {
                    eventsArrayList[position].apply {

                    }
                }
            })

        rvEventsHistory.apply {
            layoutManager = linearLayoutManager
            isNestedScrollingEnabled = false
            adapter = adapterEventHistory
        }

        getEventsApiCall(filterValues, tvStartDate.text.toString(), tvEndDate.text.toString())
    }

    /*---------------------------------------ListPopupWindow--------------------------------------*/

    private fun statusFilterPopupWindow(textView: TextView) {
        val stringArrayList = ArrayList<String>()
        statusArrayList.forEach {
            stringArrayList.add(it)
        }
        val listPopupWindow = ListPopupWindow(requireContext())
        listPopupWindow.apply {
            anchorView = textView
            isModal = true
            val stringListPopUpAdapter = DropDownAdapter(requireContext(), stringArrayList)
            setAdapter(stringListPopUpAdapter)
            setOnItemClickListener { parent, view, position, id ->
                filterValues.clear()
                statusArrayList[position].apply {
                    textView.text = this
                    textView.tag = this

                    if(textView.text.toString().equals(resources.getString(R.string.payments))){
                        filterValue="CHARGE"
                    }else{
                        filterValue=textView.text.toString()
                    }

                }
                dismiss()
            }
            show()
        }
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.tvStatusFilter -> {
                statusFilterPopupWindow(tvStatusFilter)
            }

            R.id.tvStartDate -> {
                dateTimePicker(tvStartDate)
            }

            R.id.tvEndDate -> {
                dateTimePicker(tvEndDate)
            }

            R.id.btnGO -> {
                if(filterValue == resources.getString(R.string.all)){
                    filterValues.clear()
                }else if(filterValue == resources.getString(R.string.trips)){
                    filterValues.add("IN")
                    filterValues.add("OUT")
                }else{
                    if(filterValue != ""){
                        filterValues.add(filterValue)
                    }
                }
                page=1
                eventsArrayList.clear()
                setEventsRecyclerView(filterValues,tvStartDate.text.toString(),tvEndDate.text.toString())

            }

            R.id.btnClear -> {
                tvStartDate.text=""
                tvEndDate.text=""
                tvStatusFilter.text=resources.getString(R.string.all)
                filterValue=resources.getString(R.string.all)
                if(filterValue == resources.getString(R.string.all)){
                    filterValues.clear()
                }else{
                    if(filterValue != ""){
                        filterValues.add(filterValue)
                    }
                }
                page=1
                eventsArrayList.clear()
                setEventsRecyclerView(filterValues,"","")
            }

        }
    }


    private fun dateTimePicker(textView: TextView){
        val date: Calendar = Calendar.getInstance()
        var thisAYear = date.get(Calendar.YEAR)
        var thisAMonth = date.get(Calendar.MONTH)
        var thisADay = date.get(Calendar.DAY_OF_MONTH)
        val dpd = DatePickerDialog(requireContext(), DatePickerDialog.OnDateSetListener { view, thisYear, thisMonth, thisDay ->
            // Display Selected date in textbox
            thisAMonth = thisMonth + 1
            thisADay = thisDay
            thisAYear = thisYear

            MyTimePicker.starTimePicker(
                requireContext(),
                null,
                null,
                true,
                object : TimePickerCallback {
                    override fun onTimeSelected(output: String, requestCode: Int) {
                        var time = output+":00"
                        textView.setText(thisADay.toString() + "/" +thisAMonth + "/" + thisAYear+" "+time)
                    }
                })
            //mh.entryDate = newDate.timeInMillis // setting new date
        }, thisAYear, thisAMonth, thisADay)
        dpd.datePicker.maxDate = System.currentTimeMillis()
        dpd.show()
    }

}