package com.amco.bein_beout.fragment

import android.app.Dialog
import android.os.Bundle
import android.util.Log
import android.view.*
import android.widget.Button
import android.widget.LinearLayout
import android.widget.TextView
import androidx.fragment.app.Fragment
import com.google.android.material.textfield.TextInputEditText
import com.google.gson.JsonElement
import com.amco.bein_beout.R
import com.amco.bein_beout.util.SessionManager
import com.amco.bein_beout.remote.APICallback
import com.amco.bein_beout.remote.APICalls
import com.amco.bein_beout.remote.EventAPI
import com.amco.bein_beout.util.CrashlyticsHelper
import com.amco.bein_beout.util.helper.Helper
import kotlinx.android.synthetic.main.fragment_account.*
import kotlinx.android.synthetic.main.layout_common_progress_bar.*
import retrofit2.Call
import java.text.SimpleDateFormat
import java.util.*

class AccountFragment : Fragment(), View.OnClickListener {
    private lateinit var sessionManager: SessionManager
    lateinit var currentDate:String
    private var call: Call<JsonElement>? = null
    private lateinit var totalAmount:String
    private lateinit var walletBalance:String
    lateinit var chargeUUID:String
    lateinit var chargeWalletDialog: Dialog
    lateinit var walletAmtChargeWalletDialog: Dialog

    override fun onCreateView(
        inflater: LayoutInflater,
        container: ViewGroup?,
        savedInstanceState: Bundle?,
    ): View? {
        return inflater.inflate(R.layout.fragment_account, container, false)
    }

    override fun onViewCreated(view: View, savedInstanceState: Bundle?) {
        super.onViewCreated(view, savedInstanceState)
        init()
    }

    private fun init() {
        sessionManager = SessionManager(requireContext())
        if(sessionManager.walletAmount.equals("")){
            tvProfileWalletAmount.text=resources.getString(R.string.euro)+"0"
        }else{
            tvProfileWalletAmount.text=resources.getString(R.string.euro)+sessionManager.walletAmount
        }

        tvProfileUserName.text=sessionManager.email.toString()
        llChargeWallet.setOnClickListener(this)
    }

    override fun onClick(v: View?) {
        when (v) {
            llChargeWallet -> {
                showDialog()
            }
        }
    }

    fun getRandomNumberString(): String? {
        // It will generate 6 digit random Number.
        // from 0 to 999999
        val rnd = Random()
        val number = rnd.nextInt(999999)
        // this will convert any number sequence into 6 character.
        return String.format("%06d", number)
    }

    private fun getEventApiCall(route_id:String,stop_id:String,bus_id:String,date:String,inoutstatus:String,uuid:String,price:Int) {
        rlProgressbar.visibility=View.VISIBLE
        call = EventAPI(
            requireContext(),
            sessionManager.email.toString(),
            route_id,
            stop_id,
            bus_id,
            date,
            inoutstatus,
            uuid,
            price,
            object : APICallback {
                override fun onAPIFailure(message: Int) {
                    Log.i("API_FAIL1", message.toString())
                    rlProgressbar.visibility=View.GONE
                    showError(getString(R.string.error_msg))
                }

                override fun onAPIResult(status: Int, content: JsonElement?) {
                    rlProgressbar.visibility=View.GONE
                    if (content != null) {
                        when (status) {
                            APICalls.SUCCESS -> {
                                Log.i("API_FAIL1", content.toString())
                                sessionManager.eventUuid=uuid
                                totalAmount=content.asJsonObject.getAsJsonPrimitive("totalAmount").toString()
                                walletBalance=content.asJsonObject.getAsJsonPrimitive("walletBalance").toString()

                                tvProfileWalletAmount.text=resources.getString(R.string.euro)+walletBalance
                                sessionManager.walletAmount=walletBalance

                                showWalletChargeSuccessDialog(totalAmount)
                                //showError(getString(R.string.success))
                            }
                            APICalls.FAILURE -> {
                                Log.i("API_FAIL2", content.toString())
                                showError(getString(R.string.error_msg))
                            }
                        }
                    } else {
                        rlProgressbar.visibility=View.GONE
                        Log.i("API_FAIL3", content.toString())
                        showError(getString(R.string.error_msg))
                    }
                }
            }).execute()
    }

    private fun showError(message: String, isSuccess: Boolean = false) {
        if (message.isNotEmpty()) {
            Helper.toast( message, requireContext())
        }
    }

   /*------------------- DIALOGS------------------------*/
    private fun showDialog() {
        chargeWalletDialog = Dialog(requireContext(),R.style.MaterialDialogSheetDialog)
        chargeWalletDialog.apply {
            requestWindowFeature(Window.FEATURE_NO_TITLE)
            setContentView(R.layout.dialog_add_wallet_amount)
            setCancelable(true)
            setCanceledOnTouchOutside(true)

            val time = Calendar.getInstance().time
            val formatter = SimpleDateFormat("dd/MM/yyyy HH:mm:ss")
            currentDate = formatter.format(time)

            val etWalletAmount = findViewById<TextInputEditText>(R.id.etWalletAmount)
            val btnCancel = findViewById<Button>(R.id.btnCancel)
            val btnSubmit = findViewById<Button>(R.id.btnSubmit)

            btnSubmit.setOnClickListener {

                chargeUUID= getRandomNumberString().toString()
                Log.i("chargeUUID==", chargeUUID)


                if(etWalletAmount.text.toString().equals("")||etWalletAmount.text.toString().equals("0")){
                    showError(resources.getString(R.string.please_enter_valid_amount))
                }else{
                    val price=etWalletAmount.text.toString()
                    getEventApiCall("","","",currentDate,"CHARGE",chargeUUID,price.toInt())

                    //crash analytics for amount add in wallet
                    CrashlyticsHelper.setAccountKey(etWalletAmount.text.toString())
                    chargeWalletDialog.dismiss()
                }


            }

            btnCancel.setOnClickListener { chargeWalletDialog.dismiss() }
            chargeWalletDialog.show()

            window!!.setLayout(
                LinearLayout.LayoutParams.MATCH_PARENT,
                LinearLayout.LayoutParams.WRAP_CONTENT
            )
            window!!.setGravity(Gravity.CENTER)
        }
    }

    private fun showWalletChargeSuccessDialog(amount:String) {
        walletAmtChargeWalletDialog = Dialog(requireContext(),R.style.MaterialDialogSheetDialog)
        walletAmtChargeWalletDialog.apply {
            requestWindowFeature(Window.FEATURE_NO_TITLE)
            setContentView(R.layout.dialog_wallet_amount_charge_successfully)
            setCancelable(true)
            setCanceledOnTouchOutside(true)

            val tvWalletAmountCharged = findViewById<TextView>(R.id.tvWalletAmountCharged)
            val btnOk = findViewById<Button>(R.id.btnOk)

            tvWalletAmountCharged.text=resources.getString(R.string.transaction_complete)+" "+resources.getString(R.string.euro)+amount+" "+resources.getString(R.string.amount_has_been_credited_to_your_wallet)

            btnOk.setOnClickListener {
                walletAmtChargeWalletDialog.dismiss()
            }

            walletAmtChargeWalletDialog.show()

            window!!.setLayout(
                LinearLayout.LayoutParams.MATCH_PARENT,
                LinearLayout.LayoutParams.WRAP_CONTENT
            )
            window!!.setGravity(Gravity.CENTER)
        }
    }
}