package com.amco.bein_beout.data.repository

import android.content.Context
import android.util.Log
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import com.amco.bein_beout.R
import com.amco.bein_beout.data.entity.APIResponse
import com.amco.bein_beout.data.entity.APIResult
import com.amco.bein_beout.data.entity.User
import com.amco.bein_beout.data.enum.APIErrorCode
import com.amco.bein_beout.data.enum.HTTPCode
import com.amco.bein_beout.local.DatabaseHelper
import com.amco.bein_beout.local.PreferenceManager
import com.amco.bein_beout.remote.APIManager
import com.amco.bein_beout.util.constant.Constant

import com.amco.bein_beout.util.helper.Helper


class AccountRepository(val context: Context) {

    private val api = APIManager.invoke(context)
    val db = DatabaseHelper(context)
    private val preferenceManager = PreferenceManager(context)

    fun getAccessToken() = preferenceManager.accessToken
    fun logout() = preferenceManager.clearSession()

    /**
     * this method is used for login.
     */
    suspend fun loginApi(
        email: String,
        password: String,
        listener: (APIResult<User>) -> Unit,
    ) {
        if (Helper.isNetworkAvailable(context)) {
            listener.invoke(APIResult.InProgress)
            val params = HashMap<String,String>()
            params["username"] = "analysis"
            params["password"] = "6v.NThGF"
            params["deviceUuid"] = "POS1"
            Log.d("SignInParams gson", Gson().toJson(params))
            Log.d("SignInParams==", params.toString())
            val loginPara=Gson().toJson(params)
            try {
                val response = api.loginApi(params)

               /* Log.d("SignInResponse", Gson().toJson(response.message()))
                Log.d("SignInResponse", Gson().toJson(response.body()))
                Log.d("SignInResponse", Gson().toJson(response.errorBody()))
                Log.d("SignInResponse", Gson().toJson(response))*/
                if (response.isSuccessful) {
                    Log.d("SignInResponse", Gson().toJson(response.body()))
                    response.body()?.asJsonObject?.let { jsonObject ->
                        val apiResponse: APIResponse = Gson().fromJson(jsonObject, object : TypeToken<APIResponse>() {}.type)
                        when (response.code()) {
                            HTTPCode.SUCCESS.code, HTTPCode.SUCCESS_1.code -> {
                                var user = User()
                                if (jsonObject.has("content") && !jsonObject.get("content").isJsonNull) {
                                    user = Gson().fromJson(jsonObject.get("content").asJsonObject, object : TypeToken<User>() {}.type)
                                }
                                listener(APIResult.Success(user, apiResponse.message))
                                return
                            }
                            else -> {
                                listener(
                                    APIResult.Failure(
                                        APIErrorCode.INVALID_DATA,
                                        apiResponse.message
                                    )
                                )
                                return
                            }
                        }
                    }.let {

                        listener(
                            APIResult.Failure(
                                APIErrorCode.NO_RESPONSE,
                                context.getString(R.string.error_msg)
                            )
                        )
                        return
                    }
                } else {
                    listener(
                        APIResult.Failure(
                            APIErrorCode.INVALID_DATA,
                            context.getString(R.string.error_msg)
                        )
                    )
                    return
                }
            } catch (e: Exception) {
                Log.e("error", e.message.toString())
            }

        } else {
            listener(
                APIResult.Failure(
                    APIErrorCode.NETWORK_ERROR,
                    context.getString(R.string.network_error_msg)
                )
            )
            return
        }
    }


    /**
     * this method is used for create new account.
     */
    suspend fun signUpApi(
        user: User,
        listener: (APIResult<User>) -> Unit,
    ) {
        if (Helper.isNetworkAvailable(context)) {
            listener.invoke(APIResult.InProgress)
            val params = HashMap<String, String>()
          /*  params["email"] = user.emailAddress
            params["firstName"] = user.firstName
            params["lastName"] = user.lastName*/
            params["password"] = user.password
            params["internal_version"] = Constant.INTERNAL_VERSION
            params["external_version"] = Constant.EXTERNAL_VERSION
            params["device_type"] = Constant.DEVICE_TYPE
            //params["title"] = user.title
            //params["device_token"] = preferenceRepository.getDeviceToken()


            Log.d("SignInParams", Gson().toJson(params))
            try {
                val response = api.signUpApi(params)
                if (response.isSuccessful) {
                    Log.d("SignInResponse", Gson().toJson(response.body()))
                    response.body()?.asJsonObject?.let { jsonObject ->
                        val apiResponse: APIResponse =
                            Gson().fromJson(jsonObject, object : TypeToken<APIResponse>() {}.type)
                        when (response.code()) {
                            HTTPCode.SUCCESS.code, HTTPCode.SUCCESS_1.code -> {
                                var user = User()
                                user = Gson().fromJson(
                                    jsonObject.asJsonObject,
                                    object : TypeToken<User>() {}.type
                                )
                                if (jsonObject.has("resp") && !jsonObject.get("content").isJsonNull) {
                                    user = Gson().fromJson(
                                        jsonObject.asJsonObject,
                                        object : TypeToken<User>() {}.type
                                    )
                                }
                                listener(APIResult.Success(user, apiResponse.message))
                                return
                            }
                            else -> {
                                listener(
                                    APIResult.Failure(
                                        APIErrorCode.INVALID_DATA,
                                        apiResponse.message
                                    )
                                )
                                return
                            }
                        }
                    }.let {

                        listener(
                            APIResult.Failure(
                                APIErrorCode.NO_RESPONSE,
                                context.getString(R.string.error_msg)
                            )
                        )
                        return
                    }
                } else {
                    listener(
                        APIResult.Failure(
                            APIErrorCode.INVALID_DATA,
                            context.getString(R.string.error_msg)
                        )
                    )
                    return
                }
            } catch (e: Exception) {
                Log.e("error", e.message.toString())
            }

        } else {
            listener(
                APIResult.Failure(
                    APIErrorCode.NETWORK_ERROR,
                    context.getString(R.string.network_error_msg)
                )
            )
            return
        }
    }


    suspend fun forgotPasswordApi(
        email: String,
        listener: (APIResult<String>) -> Unit,
    ) {
        if (Helper.isNetworkAvailable(context)) {
            listener.invoke(APIResult.InProgress)
            val params = HashMap<String, String>()
            params["email"] = email
            params["internal_version"] = Constant.INTERNAL_VERSION
            params["external_version"] = Constant.EXTERNAL_VERSION
            params["device_type"] = Constant.DEVICE_TYPE
            //params["device_token"] = preferenceRepository.getDeviceToken()


            Log.d("SignInParams", Gson().toJson(params))
            try {
                val response = api.forgotPasswordApi(params)
                if (response.isSuccessful) {
                    Log.d("SignInResponse", Gson().toJson(response.body()))
                    response.body()?.asJsonObject?.let { jsonObject ->
                        val apiResponse: APIResponse =
                            Gson().fromJson(jsonObject, object : TypeToken<APIResponse>() {}.type)
                        when (response.code()) {
                            HTTPCode.SUCCESS.code, HTTPCode.SUCCESS_1.code -> {
                                listener(APIResult.Success("", apiResponse.message))
                                return
                            }
                            else -> {
                                listener(
                                    APIResult.Failure(
                                        APIErrorCode.INVALID_DATA,
                                        apiResponse.message
                                    )
                                )
                                return
                            }
                        }
                    }.let {

                        listener(
                            APIResult.Failure(
                                APIErrorCode.NO_RESPONSE,
                                context.getString(R.string.error_msg)
                            )
                        )
                        return
                    }
                } else {
                    listener(
                        APIResult.Failure(
                            APIErrorCode.INVALID_DATA,
                            context.getString(R.string.error_msg)
                        )
                    )
                    return
                }
            } catch (e: Exception) {
                Log.e("error", e.message.toString())
            }

        } else {
            listener(
                APIResult.Failure(
                    APIErrorCode.NETWORK_ERROR,
                    context.getString(R.string.network_error_msg)
                )
            )
            return
        }
    }


    suspend fun resetPasswordApi(
        email: String,
        password: String,
        token: String,
        listener: (APIResult<String>) -> Unit,
    ) {
        if (Helper.isNetworkAvailable(context)) {
            listener.invoke(APIResult.InProgress)
            val params = HashMap<String, String>()
            params["email"] = email
            params["token"] = token
            params["password"] = password
            params["internal_version"] = Constant.INTERNAL_VERSION
            params["external_version"] = Constant.EXTERNAL_VERSION
            params["device_type"] = Constant.DEVICE_TYPE
            //params["device_token"] = preferenceRepository.getDeviceToken()


            Log.d("SignInParams", Gson().toJson(params))
            try {
                val response = api.resetPasswordApi(params)
                if (response.isSuccessful) {
                    Log.d("SignInResponse", Gson().toJson(response.body()))
                    response.body()?.asJsonObject?.let { jsonObject ->
                        val apiResponse: APIResponse =
                            Gson().fromJson(jsonObject, object : TypeToken<APIResponse>() {}.type)
                        when (response.code()) {
                            HTTPCode.SUCCESS.code, HTTPCode.SUCCESS_1.code -> {
                                listener(APIResult.Success("", apiResponse.message))
                                return
                            }
                            else -> {
                                listener(
                                    APIResult.Failure(
                                        APIErrorCode.INVALID_DATA,
                                        apiResponse.message
                                    )
                                )
                                return
                            }
                        }
                    }.let {

                        listener(
                            APIResult.Failure(
                                APIErrorCode.NO_RESPONSE,
                                context.getString(R.string.error_msg)
                            )
                        )
                        return
                    }
                } else {
                    listener(
                        APIResult.Failure(
                            APIErrorCode.INVALID_DATA,
                            context.getString(R.string.error_msg)
                        )
                    )
                    return
                }
            } catch (e: Exception) {
                Log.e("error", e.message.toString())
            }

        } else {
            listener(
                APIResult.Failure(
                    APIErrorCode.NETWORK_ERROR,
                    context.getString(R.string.network_error_msg)
                )
            )
            return
        }
    }

}