package com.amco.bein_beout.adapter

import android.annotation.SuppressLint
import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import android.widget.BaseAdapter
import android.widget.TextView
import com.amco.bein_beout.R

class DropDownAdapter(private val mContext: Context, private val mArrayList: ArrayList<String>) : BaseAdapter() {

    private val layoutInflater: LayoutInflater = mContext.getSystemService(Context.LAYOUT_INFLATER_SERVICE) as LayoutInflater

    private var viewHolder: ViewHolder? = null


    override fun getCount(): Int {
        return mArrayList.size
    }

    override fun getItem(i: Int): Any {
        return mArrayList[i]
    }

    override fun getItemId(i: Int): Long {
        return i.toLong()
    }

    private class ViewHolder {
        internal var txtTitle: TextView? = null

    }


    // this method  is called each time for arraylist data size.
    @SuppressLint("InflateParams")
    override fun getView(position: Int, view: View?, viewGroup: ViewGroup): View {

        var vi: View? = view
        if (vi == null) {
            // create  viewholder object for list_rowcell View.
            viewHolder =
                ViewHolder()
            // inflate list_rowcell for each row
            vi = layoutInflater.inflate(R.layout.item_drop_down, null)
            viewHolder!!.txtTitle = vi!!.findViewById<View>(R.id.tvItemDropDown) as TextView
            /*We can use setTag() and getTag() to set and get custom objects as per our requirement.
            The setTag() method takes an argument of type Object, and getTag() returns an Object.*/
            vi.tag = viewHolder
        } else {

            /* We recycle a View that already exists */
            viewHolder = vi.tag as ViewHolder
        }

        viewHolder!!.txtTitle!!.text = mArrayList[position]

        return vi
    }
}