package com.amco.bein_beout.adapter
import android.annotation.SuppressLint
import android.content.Context
import android.view.LayoutInflater
import android.view.View
import android.view.ViewGroup
import androidx.recyclerview.widget.RecyclerView
import com.amco.bein_beout.R
import com.amco.bein_beout.`interface`.ItemClickCallBack
import com.amco.bein_beout.model.Events
import kotlinx.android.synthetic.main.item_events_history.view.*

import java.util.*
import kotlin.collections.ArrayList

class AdapterEventsHistory(
    var context: Context,
    var eventsArrayList:ArrayList<Events>,
    val itemClickCallBack: ItemClickCallBack
) : RecyclerView.Adapter<AdapterEventsHistory.ViewHolder>(){

    override fun onCreateViewHolder(parent: ViewGroup, viewType: Int): ViewHolder {
        return ViewHolder(
            LayoutInflater.from(parent.context).inflate(R.layout.item_events_history, parent, false)
        )
    }

    override fun getItemCount(): Int = eventsArrayList.size

    @SuppressLint("SetTextI18n")
    override fun onBindViewHolder(holder: ViewHolder, position: Int) {
        holder.apply {
            eventsArrayList[position].apply {
                tvEventId.text=context.resources.getString(R.string.event_id)+" : "+uuidEvent
                tvVehicleNo.text=context.resources.getString(R.string.vehicle_no)+" : "+vehicleId
                tvAxisName.text=context.resources.getString(R.string.axis_name)+" : "+axisName
                tvStopName.text=context.resources.getString(R.string.stop_name)+" : "+stopName
                tvDate.text=context.resources.getString(R.string.date)+" : "+date
                tvPrice.text=context.resources.getString(R.string.price)+" : "+context.resources.getString(R.string.euro)+price
                tvStatus.text=context.resources.getString(R.string.status)+" : "+status

                if(status.equals("CHARGE")){
                    tvAxisName.visibility=View.GONE
                    tvStopName.visibility=View.GONE
                    tvVehicleNo.visibility=View.GONE
                }else{
                    tvAxisName.visibility=View.VISIBLE
                    tvStopName.visibility=View.VISIBLE
                    tvVehicleNo.visibility=View.VISIBLE
                }

                if(status.equals("IN")){
                    tvPrice.visibility=View.GONE
                }else{
                    tvPrice.visibility=View.VISIBLE
                }

                llEvents.setOnClickListener {
                    itemClickCallBack.onItemClick(adapterPosition)
                }
            }
        }
    }

    inner class ViewHolder(v: View) : RecyclerView.ViewHolder(v) {
        val tvEventId = v.tvEventUuid!!
        val tvStatus = v.tvStatus!!
        val tvVehicleNo = v.tvVehicleNo!!
        val llEvents = v.llEvents!!
        val tvAxisName = v.tvAxisName!!
        val tvStopName = v.tvStopName!!
        val tvDate = v.tvDate!!
        val tvPrice = v.tvPrice!!
    }
}