package com.amco.bein_beout.activity

import android.content.Intent
import android.os.Bundle
import android.os.Handler
import androidx.appcompat.app.AppCompatActivity
import com.amco.bein_beout.R
import com.amco.bein_beout.util.SessionManager

class SplashActivity : AppCompatActivity() {
    var sessionManager: SessionManager? = null
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_splash)
        sessionManager = SessionManager(this)
        initUI()
    }

    private fun initUI() {
        Handler().postDelayed({
            if(sessionManager!!.email.equals("")){
                val intent = Intent(this, IntroActivity::class.java)
                startActivity(intent)
            }else{
                val intent = Intent(this, MainActivity::class.java)
                intent.putExtra("email",sessionManager!!.email)
                startActivity(intent)
            }
        }, 3500)
    }
}