package com.amco.bein_beout.activity

import android.content.Intent
import android.graphics.Typeface
import android.os.Bundle
import android.text.SpannableString
import android.text.Spanned
import android.text.style.ForegroundColorSpan
import android.text.style.StyleSpan
import android.text.style.UnderlineSpan
import android.view.View
import android.widget.Toast
import androidx.lifecycle.ViewModelProvider
import com.amco.bein_beout.R
import com.amco.bein_beout.data.entity.APIResult
import com.amco.bein_beout.data.entity.User
import com.amco.bein_beout.others.BaseActivity
import com.amco.bein_beout.util.SessionManager
import com.amco.bein_beout.util.helper.Helper
import com.amco.bein_beout.model.AccountViewModel
import kotlinx.android.synthetic.main.activity_signup.*
import kotlinx.android.synthetic.main.layout_toolbar.*


class SignUpActivity : BaseActivity(),View.OnClickListener {
    var sessionManager: SessionManager? = null
    lateinit var accountViewModel: AccountViewModel
    val user = User()

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_signup)
        sessionManager = SessionManager(this)
        initUI()
    }
    private fun initUI() {
        accountViewModel = ViewModelProvider(this)[AccountViewModel::class.java]
        btnSignup.setOnClickListener(this)
        tvLogin.setOnClickListener(this)
        ivBack.setOnClickListener(this)
        tvTitle.text=getString(R.string.signup)
        ivBack.setImageResource(R.drawable.back)
        ivBack.setColorFilter(resources.getColor(R.color.colorBlack))
        tvTitle.setTextColor(resources.getColor(R.color.colorBlack))
        llToolbar.setBackgroundColor(resources.getColor(R.color.colorWhite))

        val startPosition = 16
        val endPosition = 21

        val spannableStr = SpannableString(tvLogin.getText())
        val underlineSpan = UnderlineSpan()
        spannableStr.setSpan(underlineSpan,
            startPosition,
            endPosition,
            Spanned.SPAN_INCLUSIVE_EXCLUSIVE)
        val color = resources.getColor(com.amco.bein_beout.R.color.colorPrimary)
        val backgroundColorSpan = ForegroundColorSpan(color)
        spannableStr.setSpan(backgroundColorSpan,
            startPosition,
            endPosition,
            Spanned.SPAN_INCLUSIVE_EXCLUSIVE)

        val styleSpanItalic = StyleSpan(Typeface.BOLD)

        spannableStr.setSpan(styleSpanItalic,
            startPosition,
            endPosition,
            Spanned.SPAN_INCLUSIVE_EXCLUSIVE)

        tvLogin.setText(spannableStr)
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.btnSignup -> {
                if(etSignupFirstName.text.toString().equals("")){
                    Toast.makeText(this,getString(R.string.please_enter_firstname),Toast.LENGTH_SHORT).show();
                }else if(etSignupLastName.text.toString().equals("")){
                    Toast.makeText(this,getString(R.string.please_enter_lastname),Toast.LENGTH_SHORT).show();
                }else if(etSignupEmail.text.toString().equals("")){
                    Toast.makeText(this,getString(R.string.please_enter_email),Toast.LENGTH_SHORT).show();
                }else if(etSignupPassword.text.toString().equals("")){
                    Toast.makeText(this,getString(R.string.please_enter_password),Toast.LENGTH_SHORT).show();
                }else if(etSignupConfirmPassword.text.toString().equals("")){
                    Toast.makeText(this,getString(R.string.please_enter_password),Toast.LENGTH_SHORT).show();
                }else if(!etSignupConfirmPassword.text.toString().equals(etSignupPassword.text.toString())){
                    Toast.makeText(this,getString(R.string.please_enter_same_password),Toast.LENGTH_SHORT).show();
                }else{
                    user.userFirstName=etSignupFirstName.text.toString()
                    user.userLastName=etSignupLastName.text.toString()
                    user.username=etSignupEmail.text.toString()
                    user.password=etSignupPassword.text.toString()

                    sessionManager?.email = etSignupEmail.text.toString()
                    val intent = Intent(this, HomeActivity::class.java)
                    intent.putExtra("email",etSignupEmail.text.toString())
                    startActivity(intent)
                    finishAffinity()
                }
            }

            R.id.tvLogin -> {
                finish()
            }

            R.id.ivBack -> {
                finish()
            }
        }
    }

    private fun signUpApi() {
        accountViewModel.signUpApi(user) {
            when (it) {
                is APIResult.Success -> {
                    showError(it.message?:"",true)
                    baseHandler.postDelayed({
                        sessionManager?.email = etSignupEmail.text.toString()
                        val intent = Intent(this, HomeActivity::class.java)
                        intent.putExtra("email",etSignupEmail.text.toString())
                        startActivity(intent)
                        finishAffinity()
                    }, 1000)
                    dismissDialog()
                }
                is APIResult.Failure -> {
                    showError(it.message?:"")
                    dismissDialog()
                }
                APIResult.InProgress -> {
                    showDialog()
                }
            }
        }
    }

    private fun showError(message: String, isSuccess: Boolean = false) {
        if (message.isNotEmpty()) {
            Helper.toast( message, this)
        }
    }
}