package com.amco.bein_beout.activity

import android.content.Intent
import android.os.Bundle

import android.view.View
import android.widget.Toast
import androidx.lifecycle.ViewModelProvider
import com.amco.bein_beout.R
import com.amco.bein_beout.data.entity.APIResult
import com.amco.bein_beout.others.BaseActivity
import com.amco.bein_beout.util.helper.Helper
import com.amco.bein_beout.model.AccountViewModel
import kotlinx.android.synthetic.main.activity_reset_password.*
import kotlinx.android.synthetic.main.layout_toolbar.*


class ResetPasswordActivity : BaseActivity(),View.OnClickListener {
    lateinit var accountViewModel: AccountViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_reset_password)
        initUI()
    }
    private fun initUI() {
        accountViewModel = ViewModelProvider(this)[AccountViewModel::class.java]
        btnResetPassword.setOnClickListener(this)
        ivBack.setOnClickListener(this)
        tvTitle.text=getString(R.string.reset_password)
        ivBack.setImageResource(R.drawable.back)
        ivBack.setColorFilter(resources.getColor(R.color.colorBlack))
        tvTitle.setTextColor(resources.getColor(R.color.colorBlack))
        llToolbar.setBackgroundColor(resources.getColor(R.color.colorWhite))
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.btnResetPassword -> {
               if(etResetPasswordEmail.text.toString().equals("")){
                    Toast.makeText(this,getString(R.string.please_enter_email),Toast.LENGTH_SHORT).show()
                }else if(etResetPasswordToken.text.toString().equals("")){
                    Toast.makeText(this,getString(R.string.please_enter_token_which_is_send_on_your_email),Toast.LENGTH_SHORT).show();
                }else if(etResetPasswordPassword.text.toString().equals("")){
                    Toast.makeText(this,getString(R.string.please_enter_password),Toast.LENGTH_SHORT).show();
                }else if(etResetPsswordConfirmPassword.text.toString().equals("")){
                    Toast.makeText(this,getString(R.string.please_enter_password),Toast.LENGTH_SHORT).show();
                }else if(!etResetPsswordConfirmPassword.text.toString().equals(etResetPasswordPassword.text.toString())){
                    Toast.makeText(this,getString(R.string.please_enter_same_password),Toast.LENGTH_SHORT).show();
                }else{
                   //resetPasswordApi()
                   startActivity(Intent(this, LoginActivity::class.java))
                }
            }

            R.id.ivBack -> {
                finish()
            }
        }
    }

    private fun resetPasswordApi() {
        accountViewModel.resetPasswordApi(etResetPasswordEmail.text.toString(), etResetPasswordPassword.text.toString(), "") {
            when (it) {
                is APIResult.Success -> {
                    showError(it.message ?: "")
                    baseHandler.postDelayed({
                        startActivity(Intent(this, LoginActivity::class.java))
                    }, 1000)
                    dismissDialog()
                }
                is APIResult.Failure -> {
                    showError(it.message ?: "")
                    dismissDialog()
                }
                APIResult.InProgress -> {
                    showDialog()
                }
            }
        }
    }
    private fun showError(message: String) {
        if (message.isNotEmpty()) {
            Helper.toast( message, this)
        }
    }

}