package com.amco.bein_beout.activity

import android.Manifest
import android.annotation.SuppressLint
import android.app.Dialog
import android.bluetooth.BluetoothAdapter
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.content.pm.PackageManager
import android.os.*
import android.util.Log
import android.view.MenuItem
import android.view.View
import android.view.Window
import android.widget.Button
import android.widget.TextView
import android.widget.Toast
import androidx.appcompat.app.ActionBarDrawerToggle
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import androidx.core.text.HtmlCompat
import androidx.core.view.GravityCompat
import androidx.fragment.app.Fragment
import androidx.fragment.app.FragmentTransaction
import androidx.lifecycle.Observer
import com.google.android.material.navigation.NavigationView
import com.google.gson.JsonElement
import com.amco.bein_beout.R
import com.amco.bein_beout.fragment.AccountFragment
import com.amco.bein_beout.fragment.ContactUsFragment
import com.amco.bein_beout.fragment.EventsHistoryFragment
import com.amco.bein_beout.local.DatabaseHelper
import com.amco.bein_beout.remote.APICallback
import com.amco.bein_beout.remote.APICalls
import com.amco.bein_beout.remote.EventAPI
import com.amco.bein_beout.util.CrashlyticsHelper
import com.amco.bein_beout.util.SessionManager
import com.amco.bein_beout.util.helper.Helper
import com.amco.bein_beout.model.BusStop
import com.amco.bein_beout.model.Events
import com.amco.bein_beout.model.InOutData
import com.amco.bein_beout.model.Route
import com.amco.bein_beout.remote.EventsAPI
import com.google.gson.Gson
import com.google.gson.reflect.TypeToken
import kotlinx.android.synthetic.main.activity_main.*
import kotlinx.android.synthetic.main.fragment_account.*
import kotlinx.android.synthetic.main.fragment_events_history.*
import kotlinx.android.synthetic.main.layout_current_next_stop.*
import kotlinx.android.synthetic.main.layout_current_next_stop.tvCurrentStop
import kotlinx.android.synthetic.main.layout_current_next_stop.tvNextStop
import kotlinx.android.synthetic.main.layout_menu_header.*
import kotlinx.android.synthetic.main.layout_no_data.*
import kotlinx.android.synthetic.main.layout_toolbar.*
import org.altbeacon.beacon.*
import retrofit2.Call
import java.text.SimpleDateFormat
import java.util.*
import kotlin.math.roundToInt


class MainActivity : AppCompatActivity(), View.OnClickListener, BeaconConsumer, RangeNotifier ,
    NavigationView.OnNavigationItemSelectedListener {
    private var doubleBackToExitPressedOnce = false
    private lateinit var sessionManager: SessionManager
    private val TAG = "MyActivity"
    private lateinit var mBeaconManager: BeaconManager
    lateinit var beaconId:String
    lateinit var hexatoAscii:String
    lateinit var RouteId:String
    lateinit var eventUUID:String
    var price:Int=10
    var stopId:String="0"
    var busId:String="0"
    lateinit var currentDate:String
    lateinit var date:String
    lateinit var databaseHelper: DatabaseHelper
    var onBoardStationName:String=""
    var onBoardStationCode:String=""
    var leftStationName:String=""
    var nextStationName:String=""
    var routeName:String=""
    val ACCESS_LOCATION_REQUEST=2
    var beaconDistance:Double=0.0
    private var call: Call<JsonElement>? = null
    lateinit var actionBarDrawerToggle: ActionBarDrawerToggle
    private var currentFragment: Fragment = Fragment()
    private var contactUsFragment = ContactUsFragment()
    private var eventsHistoryFragment = EventsHistoryFragment()
    private var accountFragment = AccountFragment()

    var ISSTATEINSIDE:Boolean=false
    var IS_ONCE_OPEN_IN:Boolean=false
    var IS_ONCE_OPEN_OUT:Boolean=false
    var beaconState:Int=0
    private var filterValue:String=""
    val filterValues: ArrayList<String> = ArrayList()

    private var monitoringObserver = Observer<Int> { state ->
        beaconState=state
        if (beaconState == MonitorNotifier.INSIDE) {
            val time = Calendar.getInstance().time
            val formatter = SimpleDateFormat("HH:mm dd/MM/yyyy")
            date = formatter.format(time)
            Handler().postDelayed({
                showDialog("IN")
            }, 2500)

        }/*else{
            *//*val time = Calendar.getInstance().time
            val formatter = SimpleDateFormat("HH:mm dd/MM/yyyy")
            date = formatter.format(time)
            showDialog("OUT")*//*
        }*/
    }


    private val rangingObserver = Observer<Collection<Beacon>> { beacons ->
        //Log.d(TAG, "Ranged: ${beacons.count()} beacons")
        for (beacon: Beacon in beacons) {
            Log.i(TAG, "Ranged: ${beacons.count()} beacons")
            Log.d(TAG, "$beacon about ${beacon.distance} meters away")
            Log.i(TAG, "Beacon distance: ${beacon.distance} meters away")
            beaconDistance=beacon.distance
            beaconId=beacon.id1.toString()
            val bId=beaconId.replace("-", "")
            //convert hexadecimal to ASCII character
            hexatoAscii=bId.decodeHex()
            Log.i("Hexatoascii", hexatoAscii)

            val serialNo = beacon.id1.toString().substring(0,4)
            val role = beacon.id1.toString().substring(4,6)
            val extra = hexatoAscii.substring(0,3)
            val operatorId = hexatoAscii.substring(3,7)
            busId = hexatoAscii.substring(7,10)
            RouteId = hexatoAscii.substring(10,14)
            val stopCode1 = hexatoAscii.substring(14,16)

            //stop code 2 from id2 of beacon convert decima->octal->hex number
            val id2:Int =Integer.parseInt(beacon.id2.toString())
            val stringHexa:String=Integer.toHexString(id2)
            val stopCode2=stringHexa.decodeHex()
            stopId=stopCode1+stopCode2
            leftStationName=stopCode1+stopCode2
            Log.i("stopCode2", stopCode2)

            //stop code 2 from id2 of beacon convert decima->octal->hex number
            val id3:Int =Integer.parseInt(beacon.id3.toString())
            val horivertiPos:String=Integer.toHexString(id3)

            Log.i("horivertiPos", horivertiPos)
            Log.i("RouteId", RouteId.trim())
            Log.i("Hexatoascii splitted", serialNo+" "+role+" "+operatorId+" "+busId.trim()+" "+RouteId.trim()+" "+stopId.trim()+" "+horivertiPos)

            val routesArrayList: List<Route> = databaseHelper.viewRoutes(RouteId.trim())
            for (i in 0 until routesArrayList.size) {
                routeName=routesArrayList[i].routeValue
                break
            }

            val busStopArrayList: List<BusStop> = databaseHelper.viewBusstop(RouteId.trim())
            for (i in 0 until busStopArrayList.size) {
                if(busStopArrayList[i].stopCode.equals(leftStationName.trim())){
                    nextStationName=busStopArrayList[i].stopValue
                    leftStationName=busStopArrayList[i].stopValue
                    if(i==busStopArrayList.size){
                        onBoardStationName=""
                        onBoardStationCode=""
                    }else if(i==0){
                        onBoardStationName=busStopArrayList[0].stopValue
                        onBoardStationCode=busStopArrayList[0].stopCode
                    }else if(i==1){
                        onBoardStationName=busStopArrayList[0].stopValue
                        onBoardStationCode=busStopArrayList[0].stopCode
                    }else{
                        onBoardStationName=busStopArrayList[i-1].stopValue
                        onBoardStationCode=busStopArrayList[i-1].stopCode
                    }
                }
            }
            tvNextStop.text=nextStationName
            tvCurrentStop.text=onBoardStationName
            tvBusLine.text=routeName

        }
    }

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_main)
        sessionManager = SessionManager(this)
        initUI()
    }

    fun initUI(){
        if(!filterValue.equals("")){
            filterValues.add(filterValue)
        }
        actionBarDrawerToggle = ActionBarDrawerToggle(this, drawerLayout, R.string.nav_open, R.string.nav_close)
        eventUUID= getRandomNumberString().toString()
        Log.i("eventUUID==", eventUUID)
        llMain.visibility=View.VISIBLE
        flMain.visibility=View.GONE
        // pass the Open and Close toggle for the drawer layout listener
        // to toggle the button
        drawerLayout.addDrawerListener(actionBarDrawerToggle)
        actionBarDrawerToggle.syncState()
        nav_view.setNavigationItemSelectedListener(this)
        // to make the Navigation drawer icon always appear on the action bar
        supportActionBar?.setDisplayHomeAsUpEnabled(true)
        checkPermissions()
        databaseHelper = DatabaseHelper(this)
        tvTitle.text=getString(R.string.be_in_be_out)
        ivBack.visibility=View.VISIBLE
        ivBack.setOnClickListener(this)
        ivBack.setImageDrawable(resources.getDrawable(R.drawable.img_menu))

        mBeaconManager = BeaconManager.getInstanceForApplication(this.applicationContext)
        // Detect the URL frame:
        mBeaconManager.beaconParsers.clear()
        mBeaconManager.beaconParsers.add(BeaconParser().setBeaconLayout(BeaconParser.ALTBEACON_LAYOUT))
        mBeaconManager.bind(this)
        mBeaconManager.setRegionStatePeristenceEnabled(false)

        beaconDetect()
        addRoute()
        addBusStop()

        getEventsApiCall(filterValues,"","")

        val headerView = nav_view.getHeaderView(0)
        val navUsername = headerView.findViewById<View>(R.id.tvUserEmail) as TextView
        navUsername.text = sessionManager.email!!
        //addCustomer()
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        return if (actionBarDrawerToggle.onOptionsItemSelected(item)) {
            true
        } else super.onOptionsItemSelected(item)
    }

    override fun onNavigationItemSelected(item: MenuItem): Boolean {
        // Handle navigation view item clicks here.
        when (item.itemId) {
            R.id.menu_home -> {
                // Handle the camera action
                tvTitle.text=getString(R.string.be_in_be_out)
                llMain.visibility=View.VISIBLE
                flMain.visibility=View.GONE
                val intent = Intent(this@MainActivity, MainActivity::class.java)
                startActivity(intent)
                finishAffinity()
            }
            R.id.menu_history -> {
                tvTitle.text=getString(R.string.event_history)
                llMain.visibility=View.GONE
                flMain.visibility=View.VISIBLE
                replaceFragments(eventsHistoryFragment)
            }
            R.id.menu_profile -> {
                tvTitle.text=getString(R.string.account)
                llMain.visibility=View.GONE
                flMain.visibility=View.VISIBLE
                replaceFragments(accountFragment)
            }
            R.id.menu_contact_us -> {
                tvTitle.text=getString(R.string.contact_us)
                llMain.visibility=View.GONE
                flMain.visibility=View.VISIBLE
                replaceFragments(contactUsFragment)
            }
            R.id.menu_logout -> {
                logout()
            }
        }

        drawerLayout.closeDrawer(GravityCompat.START)
        return true
    }

    override fun onClick(v: View?) {
        when (v?.id) {
             R.id.ivBack -> {
                 if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                     drawerLayout.closeDrawer(GravityCompat.START)
                 }else{
                     drawerLayout.openDrawer(GravityCompat.START)
                 }
             }
        }
    }

    override fun onBackPressed() {
        if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
            drawerLayout.closeDrawer(GravityCompat.START)
        }
        if (doubleBackToExitPressedOnce) {
            super.onBackPressed()
            return
        }
        this.doubleBackToExitPressedOnce = true
        Toast.makeText(this, "Please click BACK again to exit", Toast.LENGTH_SHORT).show()
        Handler(Looper.getMainLooper()).postDelayed(Runnable { doubleBackToExitPressedOnce = false }, 2000)
    }

    fun getRandomNumberString(): String? {
        // It will generate 6 digit random Number.
        // from 0 to 999999
        val rnd = Random()
        val number = rnd.nextInt(999999)
        // this will convert any number sequence into 6 character.
        return String.format("%06d", number)
    }

    private fun showDialog(status:String) {
        val dialog = Dialog(this,R.style.MaterialDialogSheetDialog)
        dialog.requestWindowFeature(Window.FEATURE_NO_TITLE)
        dialog.setContentView(R.layout.dialog_onborad_inout)
        dialog.setCancelable(false)
        dialog.setCanceledOnTouchOutside(true)

        val time = Calendar.getInstance().time
        val formatter = SimpleDateFormat("dd/MM/yyyy HH:mm:ss")
        currentDate = formatter.format(time)
        val tvDialogAddress = dialog.findViewById(R.id.tvDialogAddress) as TextView
        if(status.equals("IN")){
            IS_ONCE_OPEN_IN=true
            tvDialogAddress.text =HtmlCompat.fromHtml(
                resources.getString(R.string.onboard_time, date, onBoardStationName,routeName),
                HtmlCompat.FROM_HTML_MODE_LEGACY
            )
            tvBoredAddress.text=HtmlCompat.fromHtml(
                resources.getString(R.string.onboard_time, date, onBoardStationName,routeName),
                HtmlCompat.FROM_HTML_MODE_LEGACY
            )
        }else{
            IS_ONCE_OPEN_OUT=true
            tvDialogAddress.text=HtmlCompat.fromHtml(
                resources.getString(R.string.you_left_time, date, onBoardStationName,routeName),
                HtmlCompat.FROM_HTML_MODE_LEGACY
            )
            tvBoredAddress.text=HtmlCompat.fromHtml(
                resources.getString(R.string.you_left_time, date, onBoardStationName,routeName),
                HtmlCompat.FROM_HTML_MODE_LEGACY
            )
        }
        val btnNo = dialog.findViewById(R.id.btnNo) as Button
        val btnAgree = dialog.findViewById(R.id.btnAgree) as Button

        btnAgree.setOnClickListener {
            dialog.dismiss()

            if(status.equals("IN")){
                ivMain.setImageResource(R.drawable.img_qr)
                tvBoredAddress.visibility=View.VISIBLE
                databaseHelper.addINData(InOutData(eventUUID,onBoardStationName,onBoardStationCode,date,"","",""))
                getEventApiCall(RouteId.trim(),stopId,busId,currentDate,status,
                    eventUUID,price)
            }else{
                ivMain.setImageResource(R.drawable.bus_home)
                tvBoredAddress.visibility=View.GONE
              // databaseHelper.updateInOutData(sessionManager.eventUuid.toString(),date,onBoardStationName,onBoardStationCode)
                getEventApiCall(RouteId.trim(),stopId,busId,currentDate,status,sessionManager.eventUuid.toString(),price)
            }
        }
        btnNo.setOnClickListener { dialog.dismiss() }

        if(!isFinishing())
        {
            dialog.show()
        }

        //set crash analytics for IN/OUT Event Status
        CrashlyticsHelper.setEventsKey(status)
    }

    private fun beaconDetect(){
        mBeaconManager =  BeaconManager.getInstanceForApplication(this)
        val region = Region("Beacon", null, null, null)

        mBeaconManager.getRegionViewModel(region).regionState.observeForever(monitoringObserver)
        mBeaconManager.startMonitoring(region)

        mBeaconManager.getRegionViewModel(region).rangedBeacons.observe(this, rangingObserver)
        mBeaconManager.startRangingBeacons(region)
    }

    override fun onBeaconServiceConnect() {
        mBeaconManager.setRangeNotifier(RangeNotifier { beacons, region ->
            if (beacons.size > 0) {
                Log.i(TAG, "Im Interested in this Beacon: " + beacons.iterator().next().id1)
                Log.i("beacon size==", beacons.size.toString())
                val batteryLevelPercent: Long = beacons.iterator().next().getDataFields().get(0)
                Log.i("batteryLevelPercent==", batteryLevelPercent.toString())
            }
        })
        try {
            Log.i(TAG, "3")
            mBeaconManager.startRangingBeaconsInRegion(Region("Beacon", null, null, null))
            mBeaconManager.addRangeNotifier(this)
        } catch (e: RemoteException) {
            Log.i(TAG, "4")
        }
    }

    override fun didRangeBeaconsInRegion(beacons: Collection<Beacon>, region: Region?) {
        if(beacons.isNotEmpty()){
            val roundoff = ((beaconDistance * 100.0).roundToInt() / 100.0)
            Log.i("roundoff",roundoff.toString())
            if(roundoff>=2.00) {
                if (ISSTATEINSIDE) {
                    if (IS_ONCE_OPEN_OUT) {
                        ISSTATEINSIDE = false
                        IS_ONCE_OPEN_IN = false
                        IS_ONCE_OPEN_OUT = false
                    } else {
                        val time = Calendar.getInstance().time
                        val formatter = SimpleDateFormat("HH:mm dd/MM/yyyy")
                        date = formatter.format(time)
                        showDialog("OUT")
                    }
                }
            }else{
                if(beaconState==MonitorNotifier.OUTSIDE){
                    if(!IS_ONCE_OPEN_IN){
                        val time = Calendar.getInstance().time
                        val formatter = SimpleDateFormat("HH:mm dd/MM/yyyy")
                        date = formatter.format(time)
                        eventUUID= getRandomNumberString().toString()
                        showDialog("IN")
                    }
                }
            }

        }
    }

    fun String.decodeHex(): String {
        require(length % 2 == 0) {"Must have an even length"}
        return String(
            chunked(2)
                .map { it.toInt(16).toByte() }
                .toByteArray()
        )
    }

    private fun enableBT() {
        val mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter()
        if (mBluetoothAdapter == null) {
            Toast.makeText(this, "No Bluetooth found", Toast.LENGTH_SHORT).show();
        }else{
            if (!mBluetoothAdapter.isEnabled) {
                if (ActivityCompat.checkSelfPermission(this,
                        Manifest.permission.BLUETOOTH_CONNECT) != PackageManager.PERMISSION_GRANTED
                ) {
                    mBluetoothAdapter.enable()
                }
            }
        }
    }

    @SuppressLint("MissingSuperCall")
    override fun onRequestPermissionsResult(
        requestCode: Int, permissions: Array<String>,
        grantResults: IntArray,
    ) {
        when (requestCode) {
            1 -> {
                if (grantResults.isNotEmpty() && grantResults[0] ==
                    PackageManager.PERMISSION_GRANTED) {
                    if ((ContextCompat.checkSelfPermission(this@MainActivity,
                            Manifest.permission.ACCESS_FINE_LOCATION) ===
                                PackageManager.PERMISSION_GRANTED)) {
                        checkPermissions()
                    }
                } else {
                    Toast.makeText(this, "Permission Denied", Toast.LENGTH_SHORT).show()
                }
                return
            }
        }
    }

    private fun getRequiredPermissions(): Array<String> {
        val targetSdkVersion = applicationInfo.targetSdkVersion
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S && targetSdkVersion >= Build.VERSION_CODES.Q) {
            arrayOf(Manifest.permission.BLUETOOTH_SCAN, Manifest.permission.BLUETOOTH_CONNECT,Manifest.permission.ACCESS_FINE_LOCATION)
        }else arrayOf(Manifest.permission.ACCESS_COARSE_LOCATION,Manifest.permission.ACCESS_FINE_LOCATION)
    }

    private fun checkPermissions() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            val missingPermissions: Array<String> = getMissingPermissions(getRequiredPermissions())
            if (missingPermissions.isNotEmpty()) {
                requestPermissions(missingPermissions, ACCESS_LOCATION_REQUEST)
            }
        }else{
            enableBT()
        }

    }


    private fun getMissingPermissions(requiredPermissions: Array<String>): Array<String> {
        val missingPermissions: MutableList<String> = ArrayList()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            for (requiredPermission in requiredPermissions) {
                if (applicationContext.checkSelfPermission(requiredPermission) != PackageManager.PERMISSION_GRANTED) {
                    missingPermissions.add(requiredPermission)
                }
            }
            if (ContextCompat.checkSelfPermission(this, Manifest.permission.ACCESS_FINE_LOCATION) !== PackageManager.PERMISSION_GRANTED) {
                if (ActivityCompat.shouldShowRequestPermissionRationale(this@MainActivity,
                        Manifest.permission.ACCESS_FINE_LOCATION)) {
                    ActivityCompat.requestPermissions(this@MainActivity,
                        arrayOf(Manifest.permission.ACCESS_FINE_LOCATION), 1)
                } else {
                    ActivityCompat.requestPermissions(this@MainActivity,
                        arrayOf(Manifest.permission.ACCESS_FINE_LOCATION), 1)
                }
            }
        }
        return missingPermissions.toTypedArray()
    }

    private fun logout(){
        val dialog = AlertDialog.Builder(this)
        dialog.setTitle(getString(R.string.logout))
            .setMessage(getString(R.string.are_you_sure_you_want_to_logout))
            .setPositiveButton("YES") { dialog, whichButton ->
                sessionManager.logout()
                sessionManager.email=""
                /* sessionManager.deviceId=""
                 sessionManager.activeTicket=""
                 sessionManager.userName=""
                 sessionManager.userId=""
                 sessionManager.firstName=""
                 sessionManager.lastName=""
                 sessionManager.accessToken=""
                 sessionManager.userToken=""*/
                val intent = Intent(this, IntroActivity::class.java)
                startActivity(intent)
                finishAffinity()
                dialog.dismiss()
                // DO YOUR STAFF
            }
            .setNegativeButton("NO") { dialog, whichButton ->
                // DO YOUR STAFF
                dialog.dismiss()
            }
        dialog.show()
    }

    private fun addRoute(){
        databaseHelper.addRoute(Route(1,"001", "01-N.SMURNI-NEAPOLI"))
        databaseHelper.addRoute(Route(2,"006", "02-K. PLATEIA - TERMA BOLOU"))
        databaseHelper.addRoute(Route(3,"014", "03-PRAKTIKER - ALKAZAR"))
    }

    private fun addBusStop(){
        databaseHelper.addBusStop(BusStop(1,"0101", "NEA SMYRNH AFETHRIA","001"))
        databaseHelper.addBusStop(BusStop(2,"0102", "EMPORIKO KENTRO- PERIFEREIA","001"))
        databaseHelper.addBusStop(BusStop(3,"0103", "GALAKTOS","001"))
        databaseHelper.addBusStop(BusStop(4,"0104", "NOSTOS","001"))
        databaseHelper.addBusStop(BusStop(5,"0105", "ERGATIKES KATOIKIES NEAS SMYRNHS","001"))
        databaseHelper.addBusStop(BusStop(6,"0106", "AGIOS DHMHTRIOS","001"))
        databaseHelper.addBusStop(BusStop(7,"0107", "PALIO FALHRO","001"))
        databaseHelper.addBusStop(BusStop(8,"0108", "IKA NEAS SMYRNHS","001"))
        databaseHelper.addBusStop(BusStop(9,"0109", "KEP- SFAGEIA","001"))
        databaseHelper.addBusStop(BusStop(10,"0110", "START OF 31ST AUGUST","001"))
        databaseHelper.addBusStop(BusStop(11,"0111", "GENIKO NOSOKOMEIO LARISAS","001"))
        databaseHelper.addBusStop(BusStop(12,"0112", "ODEIO","001"))
        databaseHelper.addBusStop(BusStop(13,"0113", "OTE","001"))
        databaseHelper.addBusStop(BusStop(14,"0114", "DIKASTIKO MEGARO","001"))
        databaseHelper.addBusStop(BusStop(15,"0143", "KENTRIKH PLATEIA","006"))
        databaseHelper.addBusStop(BusStop(16,"0202", "FISHERIES","006"))
        databaseHelper.addBusStop(BusStop(17,"0203", "PARKO AGIOU KWNSTANTINOU","006"))
        databaseHelper.addBusStop(BusStop(18,"0204", "IPSILANTOU- HPEIROU","006"))
        databaseHelper.addBusStop(BusStop(19,"0205", "TERMA YPSHLANTOU","006"))
        databaseHelper.addBusStop(BusStop(20,"0206", "EUROBANK","006"))
        databaseHelper.addBusStop(BusStop(21,"0207", "GRAMMES VOLOU","006"))
        databaseHelper.addBusStop(BusStop(22,"0208", "S/M LIDL","006"))
        databaseHelper.addBusStop(BusStop(23,"0209", "S/M GALAXIAS","006"))
        databaseHelper.addBusStop(BusStop(24,"0210", "NIAKAS","006"))
        databaseHelper.addBusStop(BusStop(25,"0211", "S/M TSOUMANHS","006"))
        databaseHelper.addBusStop(BusStop(26,"0212", "GIANNOUKA","006"))
        databaseHelper.addBusStop(BusStop(27,"0213", "FALHRO","006"))
        databaseHelper.addBusStop(BusStop(28,"0214", "STATHMOS OTE","006"))
        databaseHelper.addBusStop(BusStop(29,"0329", "PRAKTIKER","014"))
        databaseHelper.addBusStop(BusStop(30,"0330", "BIOKARPET","014"))
        databaseHelper.addBusStop(BusStop(31,"0331", "XELIDWNH","014"))
        databaseHelper.addBusStop(BusStop(32,"0332", "STATISTIKHS","014"))
        databaseHelper.addBusStop(BusStop(33,"0333", "IMPERIAL","014"))
        databaseHelper.addBusStop(BusStop(34,"0334", "PLATEIA ABERWF","014"))
        databaseHelper.addBusStop(BusStop(35,"0335", "XALATSIS","014"))
        databaseHelper.addBusStop(BusStop(36,"0336", "FAROS","014"))
        databaseHelper.addBusStop(BusStop(37,"0337", "S/M LIDL","014"))
        databaseHelper.addBusStop(BusStop(38,"0338", "POLYKATOIKIES","014"))
        databaseHelper.addBusStop(BusStop(39,"0339", "STRATOPEDO MPOUGA","014"))
        databaseHelper.addBusStop(BusStop(40,"0340", "SARAKAKIS","014"))
        databaseHelper.addBusStop(BusStop(41,"0341", "S M MY MARKET","014"))
        databaseHelper.addBusStop(BusStop(42,"0342", "KALH KARDIA","014"))
    }

    private fun getEventApiCall(route_id:String,stop_id:String,bus_id:String,date:String,inoutstatus:String,uuid:String,price:Int) {
        call = EventAPI(
            this@MainActivity,
            sessionManager.email.toString(),
            route_id,
            stop_id,
            bus_id,
            date,
            inoutstatus,
            uuid,
            price,
            object : APICallback {
                override fun onAPIFailure(message: Int) {
                    Log.i("API_FAIL1", message.toString())
                    showError(getString(R.string.error_msg))
                }

                override fun onAPIResult(status: Int, content: JsonElement?) {
                    if (content != null) {
                        when (status) {
                            APICalls.SUCCESS -> {
                                Log.i("API_FAIL1", content.toString())
                                sessionManager.eventUuid=uuid
                                val totalAmount:String=content.asJsonObject.getAsJsonPrimitive("totalAmount").toString()
                                val walletBalanceString:String=content.asJsonObject.getAsJsonPrimitive("walletBalance").toString()
                                val walletBalance: Int = walletBalanceString.toIntOrNull() ?: 0
                                val formattedWalletBalance = if (walletBalance != 0) (walletBalance / 100).toString() else "0"
                                Log.i("totalAmount==", totalAmount)

                                //user= Gson().fromJson(content.asJsonObject, object : TypeToken<User>() {}.type)
                                //sessionManager!!.accessToken = user.token.toString()
                                showError(getString(R.string.success))
                                sessionManager.walletAmount=formattedWalletBalance
                                tveWalletMoney.text=resources.getString(R.string.euro)+formattedWalletBalance


                                if(inoutstatus.equals("OUT")){
                                    ISSTATEINSIDE=false
                                    IS_ONCE_OPEN_OUT=false
                                    IS_ONCE_OPEN_IN=false
                                    beaconState=MonitorNotifier.OUTSIDE
                                    //stopBeaconMonitor()
                                    val intent = Intent(applicationContext, FareChargeActivity::class.java)
                                    intent.putExtra("totalAmount",totalAmount)
                                    startActivity(intent)
                                }else{
                                    ISSTATEINSIDE=true
                                    beaconState=MonitorNotifier.INSIDE
                                   // beaconDetect()
                                }
                            }
                            APICalls.FAILURE -> {
                                Log.i("API_FAIL2", content.toString())
                                showError(getString(R.string.error_msg))
                            }
                        }
                    } else {
                        Log.i("API_FAIL3", content.toString())
                        showError(getString(R.string.error_msg))
                    }
                }
            }).execute()
    }

    private fun showError(message: String, isSuccess: Boolean = false) {
        if (message.isNotEmpty()) {
            Helper.toast( message, this)
        }
    }

    fun replaceFragments(fragment: Fragment?) {
        val transaction = supportFragmentManager.beginTransaction()
        transaction.setTransition(FragmentTransaction.TRANSIT_FRAGMENT_FADE)
        /*if (reload) {
            supportFragmentManager.popBackStack()
        }*/
        if (fragment != null) currentFragment = fragment
        transaction.replace(R.id.flMain, fragment!!)
       // transaction.addToBackStack(fragment.tag)
        transaction.commit()
    }

    private fun getEventsApiCall(
        filterValues: ArrayList<String>,
        startDate: String,
        endDate: String
    ) {

        call = EventsAPI(
            this,
            1,
            10,
            "id",
            "DESC",
            sessionManager.email.toString(),
            filterValues,
            startDate,
            endDate,
            object : APICallback {
                override fun onAPIFailure(message: Int) {
                    Log.i("API_FAIL1", message.toString())
                    showError(getString(R.string.error_msg))
                }

                @SuppressLint("NotifyDataSetChanged")
                override fun onAPIResult(status: Int, content: JsonElement?) {
                    if (content != null) {
                        when (status) {
                            APICalls.SUCCESS -> {
                                Log.i("API_FAIL1", content.toString())

                                val data = content.asJsonObject.getAsJsonObject("data")

// Check if the JSON elements are not null before accessing their values
                                val walletBalanceString = data?.get("walletBalance")?.asJsonPrimitive?.toString() ?: "0"
                                val dailyFareCappingString = data?.get("dailyFairCapping")?.asJsonPrimitive?.toString() ?: "0"
                                val dailyUntilNowString = data?.get("dailyUntilNow")?.asJsonPrimitive?.toString() ?: "0"

// Parse the values to integers
                                val walletBalance: Int = walletBalanceString.toIntOrNull() ?: 0
                                val dailyFareCapping: Int = dailyFareCappingString.toIntOrNull() ?: 0
                                val dailyUntilNow: Int = dailyUntilNowString.toIntOrNull() ?: 0

// Check if the parsed values are not zero before dividing by 100
                                val formattedWalletBalance = if (walletBalance != 0) (walletBalance / 100).toString() else "0"
                                val formattedDailyFareCapping = if (dailyFareCapping != 0) (dailyFareCapping / 100).toString() else "0"
                                val formattedDailyUntilNow = if (dailyUntilNow != 0) (dailyUntilNow / 100).toString() else "0"

// Store the formatted values or use them as needed
                                sessionManager.walletAmount = formattedWalletBalance
                                tveWalletMoney.text = resources.getString(R.string.euro) + formattedWalletBalance
                                tvMoneySpent.text = resources.getString(R.string.euro) + formattedDailyUntilNow
                                tvDailyCapping.text = resources.getString(R.string.euro) + formattedDailyFareCapping


                               /* val walletBalance = content.asJsonObject.getAsJsonObject("data")
                                    .get("walletBalance").asJsonPrimitive.toString()
                                val dailyFareCapping = content.asJsonObject.getAsJsonObject("data")
                                    .get("dailyFairCapping").asJsonPrimitive.toString()
                                val dailyUntilNow = content.asJsonObject.getAsJsonObject("data")
                                    .get("dailyUntilNow").asJsonPrimitive.toString()
                                sessionManager.walletAmount = walletBalance
                                tveWalletMoney.text = resources.getString(R.string.euro) + walletBalance*/

                            }

                            APICalls.FAILURE -> {
                                //  showError(getString(R.string.error_msg))
                            }
                        }
                    } else {
                        Log.i("API_FAIL3", content.toString())
                        showError(getString(R.string.error_msg))
                    }
                }
            }).execute()
    }


    private val mBroadcastReceiver: BroadcastReceiver = object : BroadcastReceiver() {
        override fun onReceive(context: Context, intent: Intent) {
            val action = intent.action

            if (action == BluetoothAdapter.ACTION_STATE_CHANGED) {
                when (intent.getIntExtra(BluetoothAdapter.EXTRA_STATE, BluetoothAdapter.ERROR)) {
                    BluetoothAdapter.STATE_OFF -> {
                        // Bluetooth is turned off
                        // Do something when Bluetooth is turned off
                        doNotTurnOffBlueTooth()
                    }
                    /*BluetoothAdapter.STATE_TURNING_OFF -> {
                        // Bluetooth is in the process of turning off
                        // Do something when Bluetooth is turning off
                        doNotTurnOffBlueTooth()
                    }*/
                    BluetoothAdapter.STATE_ON -> {
                        // Bluetooth is turned on
                        // Do something when Bluetooth is turned on
                       // showToast(context, "ON")
                    }
                    BluetoothAdapter.STATE_TURNING_ON -> {
                        // Bluetooth is in the process of turning on
                        // Do something when Bluetooth is turning on
                       // showToast(context, "Turn on")
                    }
                }
            }
        }

        private fun showToast(context: Context?, message: String) {
            Toast.makeText(context, message, Toast.LENGTH_SHORT).show()
        }
    }

    private fun doNotTurnOffBlueTooth(){
        enableBT()
        val dialog = AlertDialog.Builder(this)
        dialog.setTitle(getString(R.string.alert))
            .setMessage(getString(R.string.do_not_turn_off_bluetooth))
            .setPositiveButton("OK") { dialogInterface, whichButton ->
                dialogInterface.dismiss()
            }

        dialog.show()
    }

    override fun onPause() {
        super.onPause()
        unregisterReceiver(mBroadcastReceiver)
    }

    override fun onResume() {
        super.onResume()
        registerReceiver(mBroadcastReceiver, IntentFilter(BluetoothAdapter.ACTION_STATE_CHANGED))
    }
}