package com.amco.bein_beout.activity

import android.content.Intent
import android.graphics.Typeface
import android.os.Bundle
import android.os.Handler
import android.text.SpannableString
import android.text.Spanned
import android.text.style.ForegroundColorSpan
import android.text.style.StyleSpan
import android.text.style.UnderlineSpan
import android.util.Log
import android.view.View
import android.widget.Toast
import androidx.lifecycle.ViewModelProvider
import com.google.gson.Gson
import com.google.gson.JsonElement
import com.google.gson.reflect.TypeToken
import com.amco.bein_beout.R
import com.amco.bein_beout.data.entity.LoginCustomer
import com.amco.bein_beout.data.entity.User
import com.amco.bein_beout.local.DatabaseHelper
import com.amco.bein_beout.others.BaseActivity
import com.amco.bein_beout.remote.APICallback
import com.amco.bein_beout.remote.APICalls
import com.amco.bein_beout.remote.LoginAPI
import com.amco.bein_beout.remote.LoginCustomerAPI
import com.amco.bein_beout.util.SessionManager
import com.amco.bein_beout.util.helper.Helper
import com.amco.bein_beout.util.helper.Helper.hideKeyboard
import com.amco.bein_beout.model.AccountViewModel
import com.amco.bein_beout.model.Customers
import kotlinx.android.synthetic.main.activity_login.*
import kotlinx.android.synthetic.main.layout_common_progress_bar.*
import kotlinx.android.synthetic.main.layout_toolbar.*
import retrofit2.Call
import java.text.SimpleDateFormat
import java.util.*


class LoginActivity : BaseActivity(),View.OnClickListener {
    var sessionManager: SessionManager? = null
    lateinit var accountViewModel: AccountViewModel
    private var call: Call<JsonElement>? = null
    var user = User()
    var loginCustomer = LoginCustomer()
    lateinit var databaseHelper: DatabaseHelper

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_login)
        sessionManager = SessionManager(this)
        initUI()
    }
    private fun initUI() {
        databaseHelper = DatabaseHelper(this)
       // getLoginApiCall()
        accountViewModel = ViewModelProvider(this)[AccountViewModel::class.java]
        btnLogin.setOnClickListener(this)
        tvSignup.setOnClickListener(this)
        ivBack.setOnClickListener(this)
        tvForgotPassword.setOnClickListener(this)
        tvTitle.text=getString(R.string.login)
       // ivBack.visibility=View.GONE
        ivBack.setImageResource(R.drawable.back)
        ivBack.setColorFilter(resources.getColor(R.color.colorBlack))
        tvTitle.setTextColor(resources.getColor(R.color.colorBlack))
        llToolbar.setBackgroundColor(resources.getColor(R.color.colorWhite))
        val startPosition = 24
        val endPosition = 31

        val spannableStr = SpannableString(tvSignup.getText())
        val underlineSpan = UnderlineSpan()
        spannableStr.setSpan(underlineSpan,
            startPosition,
            endPosition,
            Spanned.SPAN_INCLUSIVE_EXCLUSIVE)
        val color = resources.getColor(R.color.colorPrimary)
        val backgroundColorSpan = ForegroundColorSpan(color)
        spannableStr.setSpan(backgroundColorSpan,
            startPosition,
            endPosition,
            Spanned.SPAN_INCLUSIVE_EXCLUSIVE)

        val styleSpanItalic = StyleSpan(Typeface.BOLD)

        spannableStr.setSpan(styleSpanItalic,
            startPosition,
            endPosition,
            Spanned.SPAN_INCLUSIVE_EXCLUSIVE)

        tvSignup.setText(spannableStr)
        addCustomer()
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.btnLogin -> {
               if(etLoginEmail.text.toString().equals("")){
                    Toast.makeText(this,getString(R.string.please_enter_email),Toast.LENGTH_SHORT).show()
                }else if(etLoginPassword.text.toString().equals("")){
                    Toast.makeText(this,getString(R.string.please_enter_password),Toast.LENGTH_SHORT).show()
                }else{
                    hideKeyboard()
                   rlProgressbar.visibility=View.VISIBLE
                   Handler().postDelayed({
                       rlProgressbar.visibility=View.GONE
                       val customerArrayList: List<Customers> = databaseHelper.viewCustomers()
                       var isSame:Boolean=false
                       for(customers in customerArrayList){
                           if(customers.email == etLoginEmail.text.toString()){
                               isSame=true
                           }
                       }
                       if(isSame){
                           rlProgressbar.visibility=View.GONE
                           sessionManager!!.email = etLoginEmail.text.toString()
                           val intent = Intent(this@LoginActivity, MainActivity::class.java)
                           startActivity(intent)
                           finishAffinity()
                       }else{
                           rlProgressbar.visibility=View.GONE
                           Toast.makeText(this,getString(R.string.please_enter_valid_credential),Toast.LENGTH_SHORT).show()
                       }
                   }, 1500)

                   //getLoginCustomerApiCall()
                  /* val customerArrayList: List<Customers> = databaseHelper.viewCustomers()
                   var isSame:Boolean=false
                   for(customers in customerArrayList){
                       if(customers.email == etLoginEmail.text.toString()){
                           isSame=true
                       }
                   }

                   if(isSame){
                       rlProgressbar.visibility=View.GONE
                       sessionManager!!.email = etLoginEmail.text.toString()
                       val intent = Intent(this@LoginActivity, HomeActivity::class.java)
                       intent.putExtra("email",etLoginEmail.text.toString())
                       startActivity(intent)
                       finishAffinity()
                   }else{
                       rlProgressbar.visibility=View.GONE
                       Toast.makeText(this,getString(R.string.please_enter_valid_credential),Toast.LENGTH_SHORT).show()
                   }*/
                }
            }

            R.id.tvSignup -> {
                val intent = Intent(this, SignUpActivity::class.java)
                startActivity(intent)
            }

            R.id.tvForgotPassword -> {
                val intent = Intent(this, ForgotPasswordActivity::class.java)
                startActivity(intent)
            }

            R.id.ivBack -> {
                finish()
            }
        }
    }

    private fun getLoginApiCall() {
        call = LoginAPI(
            this@LoginActivity,
            "adminQR",
            "testqr123!",
            object : APICallback {
                override fun onAPIFailure(message: Int) {
                    Log.i("API_FAIL1", message.toString())
                    dismissDialog()
                    showError(getString(R.string.error_msg))
                }

                override fun onAPIResult(status: Int, content: JsonElement?) {
                    if (content != null) {
                        when (status) {
                            APICalls.SUCCESS -> {
                                user= Gson().fromJson(content.asJsonObject, object : TypeToken<User>() {}.type)
                                sessionManager!!.accessToken = user.token.toString()
                                Log.i("barer token==", sessionManager!!.accessToken.toString())
                            }
                            APICalls.FAILURE -> {
                                Log.i("API_FAIL2", content.toString())
                                showError(getString(R.string.error_msg))
                            }
                        }
                    } else {
                        Log.i("API_FAIL3", content.toString())
                        showError(getString(R.string.error_msg))
                    }
                }
            }).execute()
    }

    private fun getLoginCustomerApiCall() {
        rlProgressbar.visibility=View.VISIBLE
        call = LoginCustomerAPI(
            this@LoginActivity,
            etLoginEmail.text.toString(),
            etLoginPassword.text.toString(),
            object : APICallback {
                override fun onAPIFailure(message: Int) {
                    Log.i("API_FAIL1", message.toString())
                    rlProgressbar.visibility=View.GONE
                    showError(getString(R.string.error_msg))
                }

                override fun onAPIResult(status: Int, content: JsonElement?) {
                    if (content != null) {
                        when (status) {
                            APICalls.SUCCESS -> {
                                rlProgressbar.visibility=View.GONE
                                loginCustomer= Gson().fromJson(content.asJsonObject, object : TypeToken<LoginCustomer>() {}.type)
                                sessionManager!!.deviceId= user.deviceId.toString()
                                sessionManager!!.userId= user.userId.toString()
                                sessionManager!!.userName= user.username.toString()
                                sessionManager!!.firstName= user.userFirstName.toString()
                                sessionManager!!.lastName= user.userLastName.toString()
                                sessionManager!!.email = etLoginEmail.text.toString()
                                sessionManager!!.userToken = loginCustomer.customerToken
                                val intent = Intent(this@LoginActivity, MainActivity::class.java)
                                startActivity(intent)
                                finishAffinity()
                            }
                            APICalls.FAILURE -> {
                                rlProgressbar.visibility=View.GONE
                                Log.i("API_FAIL2", content.toString())
                                showError(getString(R.string.error_msg))
                            }
                        }
                    } else {
                        rlProgressbar.visibility=View.GONE
                        Log.i("API_FAIL3", content.toString())
                        showError(getString(R.string.error_msg))
                    }
                }
            }).execute()
    }

  private fun showError(message: String, isSuccess: Boolean = false) {
      if (message.isNotEmpty()) {
          Helper.toast( message, this)
      }
  }

    private fun onDeviceResponse(content: JsonElement) {
        val objDevice =
            content.asJsonObject.get("device").asJsonObject
        //Log.i("OBJ_DEVICE:${Gson().toJson(objDevice)}")
        if (objDevice.has("uuid") && !objDevice.get("uuid").isJsonNull) {
            sessionManager!!.deviceUuid = objDevice.get("uuid").asString
        }

        if (objDevice.has("id") && !objDevice.get("id").isJsonNull) {
            sessionManager!!.deviceId = objDevice.get("id").asString
        }
        /* adminHomeArrayList[AdminFunction.set_pda.position] =
             Home(
                 AdminFunction.set_pda.toString(),
                 getString(R.string.set_pda_id),
                 getString(
                     R.string.pda_id_active,
                     sessionManager.deviceUuid
                 ),
                 R.drawable.ic_set_pda_id
             )
         adminAdapter.notifyItemChanged(AdminFunction.set_pda.position)*/
     //   updateData(true)
    }

    private fun addCustomer(){
        val time = Calendar.getInstance().time
        val formatter = SimpleDateFormat("dd/MM/yyyy")
        val date = formatter.format(time)
        databaseHelper.addCustomers(Customers(1,"v.gryparis@amco.gr", date))
        databaseHelper.addCustomers(Customers(2,"c.magalios@amco.gr", date))
        databaseHelper.addCustomers(Customers(3,"vkakavas@amco.gr", date))
        databaseHelper.addCustomers(Customers(4,"e.gavrielatou@amco.gr", date))

    }

}