

package com.amco.bein_beout.activity

import android.Manifest
import android.annotation.SuppressLint
import android.bluetooth.BluetoothAdapter
import android.content.BroadcastReceiver
import android.content.Context
import android.content.Intent
import android.content.IntentFilter
import android.content.pm.PackageManager
import android.os.*
import android.util.Log
import android.view.MenuItem
import android.view.View
import android.widget.Toast
import androidx.appcompat.app.ActionBarDrawerToggle
import androidx.appcompat.app.AlertDialog
import androidx.appcompat.app.AppCompatActivity
import androidx.core.app.ActivityCompat
import androidx.core.content.ContextCompat
import androidx.lifecycle.Observer
import com.google.gson.JsonElement
import com.amco.bein_beout.R
import com.amco.bein_beout.local.DatabaseHelper
import com.amco.bein_beout.remote.APICallback
import com.amco.bein_beout.remote.APICalls
import com.amco.bein_beout.remote.EventAPI
import com.amco.bein_beout.util.SessionManager
import com.amco.bein_beout.util.helper.Helper
import com.amco.bein_beout.model.BusStop
import com.amco.bein_beout.model.Customers
import com.amco.bein_beout.model.Route
import com.amco.bein_beout.util.BluetoothStateReceiver
import kotlinx.android.synthetic.main.activity_home.*
import kotlinx.android.synthetic.main.layout_current_next_stop.*
import kotlinx.android.synthetic.main.layout_current_next_stop.tvCurrentStop
import kotlinx.android.synthetic.main.layout_current_next_stop.tvNextStop
import kotlinx.android.synthetic.main.layout_toolbar.*
import org.altbeacon.beacon.*
import retrofit2.Call
import java.text.SimpleDateFormat
import java.util.*


@Suppress("DEPRECATED_IDENTITY_EQUALS")
class HomeActivity : AppCompatActivity(), View.OnClickListener, BeaconConsumer, RangeNotifier
{
    lateinit var email:String
    private var doubleBackToExitPressedOnce = false
    private lateinit var sessionManager: SessionManager
    private val TAG = "MyActivity"
    private var mBeaconManager: BeaconManager? = null
    lateinit var beaconId:String
    lateinit var hexatoAscii:String
    lateinit var RouteId:String
    var stopId:String="0"
    var busId:String="0"
    lateinit var date:String
    lateinit var databaseHelper: DatabaseHelper
    var onBoardStationName:String=""
    var onBoardStationCode:String=""
    var leftStationName:String=""
    var nextStationName:String=""
    var routeName:String=""
    val ACCESS_LOCATION_REQUEST=2
    private var call: Call<JsonElement>? = null
    lateinit var actionBarDrawerToggle: ActionBarDrawerToggle
    private val bluetoothStateReceiver = BluetoothStateReceiver()
    private val mBluetoothAdapter = BluetoothAdapter.getDefaultAdapter()

    @SuppressLint("SimpleDateFormat")
    private val monitoringObserver = Observer<Int> { state ->
        if (state == MonitorNotifier.INSIDE) {
            val time = Calendar.getInstance().time
            val formatter = SimpleDateFormat("HH:mm dd/MM/yyyy")
            date = formatter.format(time)
            Handler().postDelayed({
              //  showDialog("IN")
            }, 2500)

        } else {
            val time = Calendar.getInstance().time
            val formatter = SimpleDateFormat("HH:mm dd/MM/yyyy")
            date = formatter.format(time)
          //  showDialog("OUT")
        }
    }


    private val rangingObserver = Observer<Collection<Beacon>> { beacons ->
        //Log.d(TAG, "Ranged: ${beacons.count()} beacons")
        for (beacon: Beacon in beacons) {
            Log.i(TAG, "Ranged: ${beacons.count()} beacons")
            Log.d(TAG, "$beacon about ${beacon.distance} meters away")
            beaconId=beacon.id1.toString()
            val bId=beaconId.replace("-", "")
            //convert hexadecimal to ASCII character
            hexatoAscii=bId.decodeHex()
            Log.i("Hexatoascii", hexatoAscii)

            val serialNo = beacon.id1.toString().substring(0,4)
            val role = beacon.id1.toString().substring(4,6)
            val extra = hexatoAscii.substring(0,3)
            val operatorId = hexatoAscii.substring(3,7)
            busId = hexatoAscii.substring(7,10)
            RouteId = hexatoAscii.substring(10,14)
            val stopCode1 = hexatoAscii.substring(14,16)

            //stop code 2 from id2 of beacon convert decima->octal->hex number
            val id2:Int =Integer.parseInt(beacon.id2.toString())
            val stringHexa:String=Integer.toHexString(id2)
            val stopCode2=stringHexa.decodeHex()
            stopId=stopCode1+stopCode2
            leftStationName=stopCode1+stopCode2
            Log.i("stopCode2", stopCode2)

            //stop code 2 from id2 of beacon convert decima->octal->hex number
            val id3:Int =Integer.parseInt(beacon.id3.toString())
            val horivertiPos:String=Integer.toHexString(id3)

            Log.i("horivertiPos", horivertiPos)
            Log.i("RouteId", RouteId.trim())
            Log.i("Hexatoascii splitted", serialNo+" "+role+" "+operatorId+" "+busId.trim()+" "+RouteId.trim()+" "+stopId.trim()+" "+horivertiPos)

            val routesArrayList: List<Route> = databaseHelper.viewRoutes(RouteId.trim())
            for (i in 0 until routesArrayList.size) {
                routeName=routesArrayList[i].routeValue
                break
            }

            val busStopArrayList: List<BusStop> = databaseHelper.viewBusstop(RouteId.trim())
            for (i in 0 until busStopArrayList.size) {
                if(busStopArrayList[i].stopCode.equals(leftStationName.trim())){
                    nextStationName=busStopArrayList[i].stopValue
                    leftStationName=busStopArrayList[i].stopValue
                    if(i==busStopArrayList.size){
                        onBoardStationName=""
                        onBoardStationCode=""
                    }else if(i==0){
                        onBoardStationName=busStopArrayList[0].stopValue
                        onBoardStationCode=busStopArrayList[0].stopCode
                    }else if(i==1){
                        onBoardStationName=busStopArrayList[0].stopValue
                        onBoardStationCode=busStopArrayList[0].stopCode
                    }else{
                        onBoardStationName=busStopArrayList[i-1].stopValue
                        onBoardStationCode=busStopArrayList[i-1].stopCode
                    }
                }

            }
            tvNextStop.text=nextStationName
            tvCurrentStop.text=onBoardStationName
          //  tvBusLine.text=routeName
        }
    }
    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_home)
        sessionManager = SessionManager(this)


        initUI()
    }

    override fun onDestroy() {
        super.onDestroy()
       // mBeaconManager!!.unbind(this)
        // Unregister the receiver

    }



    private fun initUI(){
        checkPermissions()
        databaseHelper = DatabaseHelper(this)

        mBeaconManager = BeaconManager.getInstanceForApplication(this.applicationContext)
        // Detect the URL frame:
        mBeaconManager!!.beaconParsers.add(BeaconParser().setBeaconLayout(BeaconParser.ALTBEACON_LAYOUT))
        mBeaconManager!!.bind(this)
        mBeaconManager!!.setRegionStatePeristenceEnabled(false)
        enableBT()
        beaconDetect()
        addRoute()
        addBusStop()
        //addCustomer()
    }

    override fun onOptionsItemSelected(item: MenuItem): Boolean {
        return if (actionBarDrawerToggle.onOptionsItemSelected(item)) {
            true
        } else super.onOptionsItemSelected(item)
    }


    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.ivLogout -> {
                logout()
            }
            R.id.ivBack -> {
               /* if (drawerLayout.isDrawerOpen(GravityCompat.START)) {
                    drawerLayout.closeDrawer(GravityCompat.START)
                }else{
                    drawerLayout.openDrawer(GravityCompat.START)
                }*/
            }
        }
    }

    override fun onBackPressed() {
        if (doubleBackToExitPressedOnce) {
            super.onBackPressed()
            return
        }
        this.doubleBackToExitPressedOnce = true
        Toast.makeText(this, "Please click BACK again to exit", Toast.LENGTH_SHORT).show()
        Handler(Looper.getMainLooper()).postDelayed(Runnable { doubleBackToExitPressedOnce = false }, 2000)
    }



    private fun beaconDetect(){
        mBeaconManager =  BeaconManager.getInstanceForApplication(this)
        val region = Region("Beacon", null, null, null)

        mBeaconManager!!.getRegionViewModel(region).regionState.observeForever(monitoringObserver)
        mBeaconManager!!.startMonitoring(region)

        mBeaconManager!!.getRegionViewModel(region).rangedBeacons.observe(this, rangingObserver)
        mBeaconManager!!.startRangingBeacons(region)
    }

    override fun onResume() {
        super.onResume()
        enableBT()
    }

    override fun onBeaconServiceConnect() {
        mBeaconManager!!.setRangeNotifier(RangeNotifier { beacons, region ->
            if (beacons.size > 0) {
                Log.i(TAG, "Im Interested in this Beacon: " + beacons.iterator().next().id1)
                Log.i("beacon size==", beacons.size.toString())
                val batteryLevelPercent: Long = beacons.iterator().next().getDataFields().get(0)
                Log.i("batteryLevelPercent==", batteryLevelPercent.toString())
               /* if(beacons.size>1){
                    Toast.makeText(this, "one more beacon detected", Toast.LENGTH_SHORT).show()
                }*/
            }else{

            }
        })
        try {
            Log.i(TAG, "3")
            mBeaconManager!!.startRangingBeaconsInRegion(Region("Beacon", null, null, null))
        } catch (e: RemoteException) {
            Log.i(TAG, "4")
        }
    }

    override fun didRangeBeaconsInRegion(beacons: Collection<Beacon>, region: Region?) {
        for (beacon in beacons) {
            Log.i("InRegion==", beacons.size.toString())
            if (beacons.size > 0) {
                //Log.i(TAG, "Im Interested in this Beacon: " + beacons.iterator().next().id1)
            }else{
                Toast.makeText(this, "No beacon detected", Toast.LENGTH_SHORT).show()
            }
        }
    }

  /*  override fun onPause() {
        super.onPause()
        //mBeaconManager!!.unbind(this)
    }*/

    fun String.decodeHex(): String {
        require(length % 2 == 0) {"Must have an even length"}
        return String(
            chunked(2)
                .map { it.toInt(16).toByte() }
                .toByteArray()
        )
    }

    private fun enableBT() {

        if (!mBluetoothAdapter.isEnabled) {
            if (ActivityCompat.checkSelfPermission(this,
                    Manifest.permission.BLUETOOTH_CONNECT) != PackageManager.PERMISSION_GRANTED
            ) {
                mBluetoothAdapter.enable()
            }
        }
    }

    @SuppressLint("MissingSuperCall")
    override fun onRequestPermissionsResult(
        requestCode: Int, permissions: Array<String>,
        grantResults: IntArray,
    ) {
        when (requestCode) {
            1 -> {
                if (grantResults.isNotEmpty() && grantResults[0] ==
                    PackageManager.PERMISSION_GRANTED) {
                    if ((ContextCompat.checkSelfPermission(this@HomeActivity,
                            Manifest.permission.ACCESS_FINE_LOCATION) ===
                                PackageManager.PERMISSION_GRANTED)) {
                        Toast.makeText(this, "Permission Granted", Toast.LENGTH_SHORT).show()
                        checkPermissions()
                    }
                } else {
                    Toast.makeText(this, "Permission Denied", Toast.LENGTH_SHORT).show()
                }
                return
            }
        }
    }
    private fun getRequiredPermissions(): Array<String> {
        val targetSdkVersion = applicationInfo.targetSdkVersion
        return if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S && targetSdkVersion >= Build.VERSION_CODES.S) {
            arrayOf(Manifest.permission.BLUETOOTH_SCAN, Manifest.permission.BLUETOOTH_CONNECT,Manifest.permission.ACCESS_FINE_LOCATION,Manifest.permission.ACCESS_COARSE_LOCATION)
        }else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.S && targetSdkVersion < Build.VERSION_CODES.S) {
            arrayOf(Manifest.permission.BLUETOOTH_CONNECT,Manifest.permission.BLUETOOTH_SCAN,Manifest.permission.ACCESS_FINE_LOCATION )
        }else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.Q && targetSdkVersion >= Build.VERSION_CODES.Q) {
            arrayOf(Manifest.permission.ACCESS_FINE_LOCATION)
        } else if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.P && targetSdkVersion >= Build.VERSION_CODES.P) {
            arrayOf(Manifest.permission.ACCESS_FINE_LOCATION)
        } else arrayOf(Manifest.permission.ACCESS_COARSE_LOCATION)
    }


    private fun checkPermissions() {
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            val missingPermissions: Array<String> = getMissingPermissions(getRequiredPermissions())
            if (missingPermissions.isNotEmpty()) {
                requestPermissions(missingPermissions, ACCESS_LOCATION_REQUEST)
            }
        }else{
            enableBT()
        }

    }

    private fun getMissingPermissions(requiredPermissions: Array<String>): Array<String> {
        val missingPermissions: MutableList<String> = ArrayList()
        if (Build.VERSION.SDK_INT >= Build.VERSION_CODES.M) {
            for (requiredPermission in requiredPermissions) {
                if (applicationContext.checkSelfPermission(requiredPermission) != PackageManager.PERMISSION_GRANTED) {
                    missingPermissions.add(requiredPermission)
                }
            }
            if (ContextCompat.checkSelfPermission(this@HomeActivity,
                    Manifest.permission.ACCESS_FINE_LOCATION) !==
                PackageManager.PERMISSION_GRANTED) {
                if (ActivityCompat.shouldShowRequestPermissionRationale(this@HomeActivity,
                        Manifest.permission.ACCESS_FINE_LOCATION)) {
                    ActivityCompat.requestPermissions(this@HomeActivity,
                        arrayOf(Manifest.permission.ACCESS_FINE_LOCATION), 1)
                } else {
                    ActivityCompat.requestPermissions(this@HomeActivity,
                        arrayOf(Manifest.permission.ACCESS_FINE_LOCATION), 1)
                }
            }
        }
        return missingPermissions.toTypedArray()
    }

    private fun logout(){
        val dialog = AlertDialog.Builder(this)
        dialog.setTitle(getString(R.string.logout))
            .setMessage(getString(R.string.are_you_sure_you_want_to_logout))
            .setPositiveButton("YES") { dialog, whichButton ->
                sessionManager.logout()
                sessionManager.email=""
               /* sessionManager.deviceId=""
                sessionManager.activeTicket=""
                sessionManager.userName=""
                sessionManager.userId=""
                sessionManager.firstName=""
                sessionManager.lastName=""
                sessionManager.accessToken=""
                sessionManager.userToken=""*/
                val intent = Intent(this, IntroActivity::class.java)
                startActivity(intent)
                finishAffinity()
                dialog.dismiss()
                // DO YOUR STAFF
            }
            .setNegativeButton("NO") { dialog, whichButton ->
                // DO YOUR STAFF
                 dialog.dismiss()
            }
        dialog.show()
    }

    private fun addRoute(){
        databaseHelper.addRoute(Route(1,"001", "01-N.SMURNI-NEAPOLI"))
        databaseHelper.addRoute(Route(2,"006", "02-K. PLATEIA - TERMA BOLOU"))
        databaseHelper.addRoute(Route(3,"014", "03-PRAKTIKER - ALKAZAR"))
    }

    private fun addBusStop(){
        databaseHelper.addBusStop(BusStop(1,"0101", "NEA SMYRNH AFETHRIA","001"))
        databaseHelper.addBusStop(BusStop(2,"0102", "EMPORIKO KENTRO- PERIFEREIA","001"))
        databaseHelper.addBusStop(BusStop(3,"0103", "GALAKTOS","001"))
        databaseHelper.addBusStop(BusStop(4,"0104", "NOSTOS","001"))
        databaseHelper.addBusStop(BusStop(5,"0105", "ERGATIKES KATOIKIES NEAS SMYRNHS","001"))
        databaseHelper.addBusStop(BusStop(6,"0106", "AGIOS DHMHTRIOS","001"))
        databaseHelper.addBusStop(BusStop(7,"0107", "PALIO FALHRO","001"))
        databaseHelper.addBusStop(BusStop(8,"0108", "IKA NEAS SMYRNHS","001"))
        databaseHelper.addBusStop(BusStop(9,"0109", "KEP- SFAGEIA","001"))
        databaseHelper.addBusStop(BusStop(10,"0110", "START OF 31ST AUGUST","001"))
        databaseHelper.addBusStop(BusStop(11,"0111", "GENIKO NOSOKOMEIO LARISAS","001"))
        databaseHelper.addBusStop(BusStop(12,"0112", "ODEIO","001"))
        databaseHelper.addBusStop(BusStop(13,"0113", "OTE","001"))
        databaseHelper.addBusStop(BusStop(14,"0114", "DIKASTIKO MEGARO","001"))
        databaseHelper.addBusStop(BusStop(15,"0143", "KENTRIKH PLATEIA","006"))
        databaseHelper.addBusStop(BusStop(16,"0202", "FISHERIES","006"))
        databaseHelper.addBusStop(BusStop(17,"0203", "PARKO AGIOU KWNSTANTINOU","006"))
        databaseHelper.addBusStop(BusStop(18,"0204", "IPSILANTOU- HPEIROU","006"))
        databaseHelper.addBusStop(BusStop(19,"0205", "TERMA YPSHLANTOU","006"))
        databaseHelper.addBusStop(BusStop(20,"0206", "EUROBANK","006"))
        databaseHelper.addBusStop(BusStop(21,"0207", "GRAMMES VOLOU","006"))
        databaseHelper.addBusStop(BusStop(22,"0208", "S/M LIDL","006"))
        databaseHelper.addBusStop(BusStop(23,"0209", "S/M GALAXIAS","006"))
        databaseHelper.addBusStop(BusStop(24,"0210", "NIAKAS","006"))
        databaseHelper.addBusStop(BusStop(25,"0211", "S/M TSOUMANHS","006"))
        databaseHelper.addBusStop(BusStop(26,"0212", "GIANNOUKA","006"))
        databaseHelper.addBusStop(BusStop(27,"0213", "FALHRO","006"))
        databaseHelper.addBusStop(BusStop(28,"0214", "STATHMOS OTE","006"))
        databaseHelper.addBusStop(BusStop(29,"0329", "PRAKTIKER","014"))
        databaseHelper.addBusStop(BusStop(30,"0330", "BIOKARPET","014"))
        databaseHelper.addBusStop(BusStop(31,"0331", "XELIDWNH","014"))
        databaseHelper.addBusStop(BusStop(32,"0332", "STATISTIKHS","014"))
        databaseHelper.addBusStop(BusStop(33,"0333", "IMPERIAL","014"))
        databaseHelper.addBusStop(BusStop(34,"0334", "PLATEIA ABERWF","014"))
        databaseHelper.addBusStop(BusStop(35,"0335", "XALATSIS","014"))
        databaseHelper.addBusStop(BusStop(36,"0336", "FAROS","014"))
        databaseHelper.addBusStop(BusStop(37,"0337", "S/M LIDL","014"))
        databaseHelper.addBusStop(BusStop(38,"0338", "POLYKATOIKIES","014"))
        databaseHelper.addBusStop(BusStop(39,"0339", "STRATOPEDO MPOUGA","014"))
        databaseHelper.addBusStop(BusStop(40,"0340", "SARAKAKIS","014"))
        databaseHelper.addBusStop(BusStop(41,"0341", "S M MY MARKET","014"))
        databaseHelper.addBusStop(BusStop(42,"0342", "KALH KARDIA","014"))
    }

    private fun addCustomer(){
        databaseHelper.addCustomers(Customers(1,"v.gryparis@ amco.gr", "24-11-2022"))
        databaseHelper.addCustomers(Customers(2,"c.magalios@amco.gr", "24-11-2022"))
        databaseHelper.addCustomers(Customers(3,"vkakavas@amco.gr", "24-11-2022"))

    }

    private fun getEventApiCall(route_id:String,stop_id:String,bus_id:String,date:String,inoutstatus:String,uuid:String,price:Int) {
        call = EventAPI(
            this@HomeActivity,
            sessionManager.email.toString(),
            route_id,
            stop_id,
            bus_id,
            date,
            inoutstatus,
            uuid,
            price,
            object : APICallback {
                override fun onAPIFailure(message: Int) {
                    Log.i("API_FAIL1", message.toString())
                    showError(getString(R.string.error_msg))
                }

                override fun onAPIResult(status: Int, content: JsonElement?) {
                    if (content != null) {
                        when (status) {
                            APICalls.SUCCESS -> {
                                //user= Gson().fromJson(content.asJsonObject, object : TypeToken<User>() {}.type)
                                //sessionManager!!.accessToken = user.token.toString()
                                showError(getString(R.string.success))

                                if(inoutstatus.equals("OUT")){
                                    val intent = Intent(applicationContext, FareChargeActivity::class.java)
                                    startActivity(intent)
                                }
                            }
                            APICalls.FAILURE -> {
                                Log.i("API_FAIL2", content.toString())
                                showError(getString(R.string.error_msg))
                            }
                        }
                    } else {
                        Log.i("API_FAIL3", content.toString())
                        showError(getString(R.string.error_msg))
                    }
                }
            }).execute()
    }

    private fun showError(message: String, isSuccess: Boolean = false) {
        if (message.isNotEmpty()) {
            Helper.toast( message, this)
        }
    }


}