package com.amco.bein_beout.activity

import android.os.Bundle
import android.view.View
import android.widget.Toast
import com.amco.bein_beout.R
import com.amco.bein_beout.data.entity.APIResult
import com.amco.bein_beout.others.BaseActivity
import com.amco.bein_beout.util.helper.Helper
import com.amco.bein_beout.model.AccountViewModel
import kotlinx.android.synthetic.main.activity_forgot_password.*
import kotlinx.android.synthetic.main.layout_toolbar.*


class ForgotPasswordActivity : BaseActivity(),View.OnClickListener {
    lateinit var accountViewModel: AccountViewModel

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_forgot_password)
        initUI()
    }
    private fun initUI() {
        btnForgotPasswordSubmit.setOnClickListener(this)
        ivBack.setOnClickListener(this)
        tvTitle.text=getString(R.string.label_forgot_password)
        ivBack.setImageResource(R.drawable.back)
        ivBack.setColorFilter(resources.getColor(R.color.colorBlack))
        tvTitle.setTextColor(resources.getColor(R.color.colorBlack))
        llToolbar.setBackgroundColor(resources.getColor(R.color.colorWhite))
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.btnForgotPasswordSubmit -> {
                if(etForgotPasswordEmail.text.toString().equals("")){
                    Toast.makeText(this,getString(R.string.please_enter_email),Toast.LENGTH_SHORT).show();
                }else{
                    //forgotPasswordApi()
                    finish()
                }
            }
            R.id.ivBack -> {
                finish()
            }
        }
    }

    private fun forgotPasswordApi() {
        accountViewModel.forgotPasswordApi(etForgotPasswordEmail.text.toString()) {
            when (it) {
                is APIResult.Success -> {
                    showError(it.message ?: "", true)
                    baseHandler.postDelayed({
                        finish()
                    }, 1000)
                    dismissDialog()
                }
                is APIResult.Failure -> {
                    dismissDialog()
                }
                APIResult.InProgress -> {
                    showDialog()
                }
            }
        }
    }

    private fun showError(message: String, isSuccess: Boolean = false) {
        if (message.isNotEmpty()) {
            Helper.toast( message, this)
        }
    }
}