package com.amco.bein_beout.activity

import android.annotation.SuppressLint
import android.content.Intent
import android.os.Bundle
import android.os.Handler
import android.text.Html
import android.view.View
import com.amco.bein_beout.R
import com.amco.bein_beout.others.BaseActivity
import kotlinx.android.synthetic.main.activity_fare_charge.*


class FareChargeActivity : BaseActivity(),View.OnClickListener {
    lateinit var totalAmount:String

    override fun onCreate(savedInstanceState: Bundle?) {
        super.onCreate(savedInstanceState)
        setContentView(R.layout.activity_fare_charge)
        initUI()
    }

    private fun initUI() {
        totalAmount= intent.getStringExtra("totalAmount")!!
        btnOk.setOnClickListener(this)
        tvFare.setText(Html.fromHtml(resources.getString(R.string.your_fare_charges)+" "+"<b>" +resources.getString(R.string.euro)+totalAmount+ "</b>"))
    }

    override fun onClick(v: View?) {
        when (v?.id) {
            R.id.ivBack -> {
                finish()
            }
            R.id.btnOk -> {
                finish()
            }

        }
    }

    override fun onBackPressed() {
        super.onBackPressed()
        finish()
    }
}